/**
 * Copyright Kow ( http://wonderfl.net/user/Kow )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/72OQ
 */

// forked from gaina's soundtest4
package  
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.filters.*;
    import com.gskinner.geom.*;

    /**
     * ...
     * @author gaina
     */
    [SWF(width=465,height=465,backgroundColor="0x000000", frameRate="30")]
    public class Rectangle extends Sprite
    {
        
        private var rect:Sprite;
        private var spArray:Array = [];
        private var containerArray:Array = [];
        private var snd:Sound;
        private var wSize:Number;
        private var vSize:Number;
        private var t:Number = 0;        
        private var ro:Number;
        private var go:Number;
        private var bo:Number;
        private var f:ColorMatrixFilter = new ColorMatrixFilter();
        private var cm:ColorMatrix = new ColorMatrix();
        
        public function Rectangle() 
        {
            wSize = stage.stageWidth / 16;
            vSize = stage.stageHeight / 8;

            containerArray = rectDraw();
            
            playSound('http://www.takasumi-nagai.com/soundfiles/01.mp3');
            
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        private function playSound(url:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(0, true);
            var sndReq:URLRequest = new URLRequest(url);
            snd.load(sndReq,context);
            var sndCh:SoundChannel = new SoundChannel();
            sndCh = snd.play(0, 5);
        }

        private function onEnter(event:Event):void
        {
            //t = ( t < 5 ) ? t+0.01 : 0;
            t = 0.1;
            
            var sp:Sprite = new Sprite();
            var byte:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum( byte, false, 1 );
            var i:int;
            for (i = 0; i < 148; i++) {
                sp = containerArray[i];
                var rl:Number = byte.readFloat();
                sp.z = rl * 150;
                sp.alpha = 0.5 + 0.5*rl;
                //sp.filters = [new GlowFilter(0x000ccff,1,16*rl,16*rl,3,3)];

                cm.adjustHue( t );
                f.matrix = cm
                sp.filters = [ f ];
           }
        }
   
        private function rectDraw():Array
        {

            var i:int, j:int;
            
            for (i = 0; i < 8; i++) {
                for (j = 0; j < 16; j++) {
                    rect = new Sprite();
                    rect.graphics.clear();
                    //rect.graphics.lineStyle(0,0xffffff);
                    rect.graphics.beginFill( 0x00ffff, 0.75 );
                    rect.graphics.drawRect(0, 0, wSize, vSize);
                    //rect.filters = ( (i+4) % 4 == 0 && j % 2 == 0 ) ? [new GlowFilter(0x000ccff,1,30,30,5,2)] : null;
                    rect.x = j * wSize;
                    rect.y = i * vSize;
                    rect.z = 0;
                    addChild(rect);
                    spArray.push(rect);
                }
            }
            
            return spArray;
        }        
    }
}

