/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7104
 */

// forked from 9re's How Can i get the f**king right TextLineMirrorRegion?
// forked from 9re's flash on 2010-5-3
package {

    import flash.display.Sprite;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextLine;
    import flash.text.engine.TextElement;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    import flash.text.engine.ContentElement;
    import flash.text.engine.GroupElement;
    import flash.text.engine.TextLineMirrorRegion;
    import flash.events.MouseEvent;
    import flash.events.EventDispatcher;
    import flash.ui.Mouse;

    import flash.events.Event;
    public class TextLineMirrorRegionExample extends Sprite {
        
        private var fontDescription:FontDescription = new FontDescription();
        private var textBlock:TextBlock = new TextBlock();

        public function TextLineMirrorRegionExample():void {
            
            fontDescription.fontWeight = "bold";
            var blackFormat:ElementFormat = new ElementFormat();
            blackFormat.fontSize = 18;
            blackFormat.color = 0x000000;
            blackFormat.fontDescription = fontDescription;
            
            /**
	            attaching new EventDispatcher to each element can avoid the problem.
	            see http://wonderfl.net/c/sdKZ
            */
            
            var textElement1:TextElement = new TextElement("Click on different parts of me to find the ", blackFormat);
            var textElement2:TextElement = new TextElement("mirror ",blackFormat);
            var textElement3:TextElement = new TextElement("regions",blackFormat);
            var textElement4:TextElement = new TextElement(". If I am a mirror region, I'll ",blackFormat);
            var textElement5:TextElement = new TextElement("turn red",blackFormat);
            var textElement6:TextElement = new TextElement(".",blackFormat);
            
            var groupVector:Vector.<ContentElement> = new Vector.<ContentElement>;
            groupVector.push(textElement1, textElement2, textElement3, textElement4, textElement5, textElement6);
            var groupElement:GroupElement = new GroupElement(groupVector);
            
            textElement2.eventMirror = getEventMirror();
            textElement3.eventMirror = getEventMirror();
            textElement5.eventMirror = getEventMirror();
            
            textBlock.content = groupElement;
            createLines(textBlock);
        }
        
        private function getEventMirror():EventDispatcher {
        		var mirror:EventDispatcher = new EventDispatcher;
        		
        		mirror.addEventListener(MouseEvent.CLICK, bind(clickHandler, mirror));
        		mirror.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
        		mirror.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
        		
        		return mirror;
        }
    
        private function clickHandler(mirror:EventDispatcher, event:MouseEvent):void
        {
            var redFormat:ElementFormat = new ElementFormat();
            redFormat.color = 0xCC0000;
            redFormat.fontSize = 18;
            redFormat.fontDescription = fontDescription;
            var line:TextLine = event.target as TextLine;
            trace(event.currentTarget);
            var region:TextLineMirrorRegion = line.getMirrorRegion(mirror);
            region.element.elementFormat = redFormat;
            createLines(textBlock);
        }
        
        private function mouseOverHandler(event:MouseEvent):void
        {
            Mouse.cursor = "button";
        }
        
        private function mouseOutHandler(event:MouseEvent):void
        {
            Mouse.cursor = "arrow";
        }
            
        private function createLines(textBlock:TextBlock):void 
        {
            var purgeLine:TextLine = textBlock.firstLine;
                
            while (purgeLine)
            {
                removeChild (purgeLine);
                purgeLine = purgeLine.nextLine;
            }
            var lineWidth:Number = 150;
            var xPos:Number = 15.0;
            var yPos:Number = 20.0;
            var textLine:TextLine = textBlock.createTextLine (null, lineWidth);
                
            while (textLine)
            {
                textLine.x = xPos;
                textLine.y = yPos;
                yPos += textLine.height + 2;
                addChild (textLine);
                textLine = textBlock.createTextLine (textLine, lineWidth);
            }
        }
        
        private function bind(func:Function, ...args):Function {
        		return function (e:Event):void {
        			func.apply(null, args.concat(e));
        		}
        }
    }
}