/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/70pF
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    
    public class FlashTest extends Sprite {
        
        private var _btn1:Button;
        private var _btn2:Button;
        private var _btn3:Button;
        static private var _log:TextField;
        
        public function FlashTest() {
            _btn1 = Button(addChild(new Button(1, "bottom")));
            _btn2 = Button(addChild(new Button(2, "middle")));
            _btn3 = Button(addChild(new Button(3, "top")));
            
            _log = TextField(stage.addChild(new TextField()));
            _log.width = _log.height = 465;
            _log.mouseEnabled = false;
        }
        
        static public function trace(...args):void {
            _log.appendText(args.join(", ") + "\n");
        }
    }
}

import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.geom.Point;

internal class Button extends Sprite {
    public function Button(index:int, name:String):void {
        name = name;
        x = (465 >> 1) + 70 * Math.cos(index * Math.PI * 2 / 3 - Math.PI / 2);
        y = (465 >> 1) + 70 * Math.sin(index * Math.PI * 2 / 3 - Math.PI / 2);
        alpha = 0.2;
        buttonMode = true;
        graphics.beginFill([0xff0000, 0x00ff00, 0x0000ff][index - 1]);
        graphics.drawCircle(0, 0, 100);
        graphics.endFill();
        addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void { _check(e); FlashTest.trace("click : " + name); } );
        addEventListener(MouseEvent.ROLL_OVER, function(e:MouseEvent):void { alpha = 0.4; } );
        addEventListener(MouseEvent.ROLL_OUT, function(e:MouseEvent):void { alpha = 0.2; } );
   }
   
   private function _check(e:MouseEvent):void {
       var list:Array = stage.getObjectsUnderPoint(new Point(e.stageX, e.stageY));
       var n:int = list.length;
       var o:DisplayObject;
       for (var i:int = 0; i < n; ++i) {
           o = list[i];
           if (o === this) continue;
           if (o.hasEventListener(e.type)) {
               o.dispatchEvent(e);
           }
       }
   }
}
