/**
 * Copyright betray.7777 ( http://wonderfl.net/user/betray.7777 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/70ng
 */

// forked from uwi's forked from: 万有引力
// forked from takenosin's 万有引力
// forked from takenosin's パーティクル
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(frameRate=60)]
    public class ClassName extends Sprite {
        
        private var Particles:Array;
        private var numParticles:uint = 150;
        
        public function ClassName() {
                graphics.beginFill(0x0);
                graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
                graphics.endFill();
            
            Particles = new Array();
            for(var i:uint = 0; i < numParticles; i++){
                var mass : Number = Math.random() * Math.random() * 10 + 1;
                var Particle:Ball = new Ball(Math.pow(mass, 1/3) * 4, 0xff0000);
                Particle.x = Math.random() * stage.stageWidth;
                Particle.y = Math.random() * stage.stageHeight;
                Particle.mass = mass;
                Particle.alpha = mass / 15 + 0.1;
                addChild(Particle);
                Particles.push(Particle);
            }
            
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
            
        }
        
        private function onEnterFrame(event:Event):void{
            
            var gx : Number = 0;
            var gy : Number = 0;
            var smass : Number = 0;
        for(var i:uint = 0; i < numParticles; i++){
        var Particle:Ball = Particles[i];
            Particle.x += Particle.vx;
            Particle.y += Particle.vy;
            gx += (Particle.x - stage.stageWidth / 2) * Particle.mass;
            gy += (Particle.y - stage.stageHeight / 2) * Particle.mass;
            smass += Particle.mass;
            }
            gx /= smass;
            gy /= smass;
            
        for(i = 0; i < numParticles; i++){
        Particle = Particles[i];
            Particle.x -= gx;
            Particle.y -= gy;
            }
            
            for(i = 0; i < numParticles - 1; i++){
                var PartA:Ball = Particles[i];
                for(var j:uint = i + 1; j < numParticles; j++){
                    var PartB:Ball = Particles[j];
                    gravitate(PartA,PartB);
                }
            }          
        }
        private function gravitate(PartA:Ball,PartB:Ball):void{
            var dx:Number = PartB.x - PartA.x;
            var dy:Number = PartB.y - PartA.y;
            var distSQ:Number = dx * dx + dy * dy;
            var dist:Number = Math.sqrt(distSQ);
            if(dist < 50)dist = 50; 
            var force:Number = PartA.mass * PartB.mass / distSQ;
            var ax:Number = force * dx / dist;
            var ay:Number = force * dy / dist;
            PartA.vx += ax / PartA.mass;
            PartA.vy += ay / PartA.mass;
            PartB.vx -= ax / PartB.mass;
            PartB.vy -= ay / PartB.mass;
        }
    }
}


import flash.display.Sprite;
class Ball extends Sprite{
    
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var mass:Number = 1;
    
    public function Ball(radius:Number=40,color:uint=0x66ffff){
        this.radius = radius;
        this.color = color;
        
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill();
    }
}