/**
 * Copyright terravilor ( http://wonderfl.net/user/terravilor )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6zaQ
 */

// forked from terravilor's Random (Sine wave)
// forked from terravilor's Pulse (Sine wave)
// forked from terravilor's Sine wave
package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class DrawWave extends Sprite {
        private var ball:Ball;
        
        private var angle:Number;
        private var centerY:Number;
        private var range:Number;
        private var xspeed:Number;
        private var yspeed:Number;
        private var xpos:Number;
        private var ypos:Number;
        
        public function DrawWave() {
            init();
        }
        
        public function init():void {
            graphics.lineStyle(1, 0, 1);
            graphics.moveTo(0, stage.stageHeight / 2)
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            //set vars
            angle = 0;
            centerY = stage.stageHeight / 2;
            range = 70;
            xspeed = 1;
            yspeed = .05;
            xpos = 0;
        }
        
        protected function onEnterFrame(event:Event):void {
            xpos += xspeed;
            angle += yspeed;
            ypos = centerY + Math.sin(angle) * range;
            graphics.lineTo(xpos, ypos);
        }


    }
}

//ball class

import flash.display.Sprite;

class Ball extends Sprite {
    private var radius:Number;
    private var color:uint;
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}
