/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ywP
 */

package {
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private var c1:Circle = new Circle(0x999999);
        private var c2:Circle = new Circle(0x999999);
        private var time:int  = 0;
        private var omega:Number = 2 * Math.PI / 180;
        private var radius:Number = 150;
        private var centerX:Number = 200;
        private var centerY:Number = 200;
        private var vArrow:Arrow = new Arrow(0xFF0000);
        private var aArrow:Arrow = new Arrow(0x0000FF);
        private var vArrow2:Arrow = new Arrow(0xFF0000);
        private var aArrow2:Arrow = new Arrow(0x0000FF);
        
        private var isPlaying:Boolean = true;
        
        public function FlashTest() {
            addChild(c1);
            addChild(c2);
            c2.x = 400;
            
            addChild(vArrow);
            addChild(aArrow);
            addChild(vArrow2);
            addChild(aArrow2);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
             
        private function onEnterFrame(e:Event):void {
           c1.x = centerX + radius * Math.cos(omega * time);
           c1.y = centerY - radius * Math.sin(omega * time);           
        
           c2.y = c1.y;
           
           var g:Graphics = graphics;
           g.clear();
           g.lineStyle(1, 0x000000);
           
           g.drawCircle(200, 200, 150);
           g.moveTo(c2.x, centerY + radius + 20);
           g.lineTo(c2.x, centerY - radius - 20);
           g.moveTo(c2.x - 10, centerY - radius);
           g.lineTo(c2.x, centerY - radius - 20);
           g.lineTo(c2.x + 10, centerY - radius);
           
           g.moveTo(c1.x, c1.y);
           g.lineTo(c2.x, c2.y);
           
           vArrow.transformArrow(c1.x, c1.y, 10 * radius * omega , Math.atan2(centerY - c1.y, centerX - c1.x)+ Math.PI / 2);
           aArrow.transformArrow(c1.x, c1.y, 250 * radius * omega * omega, Math.atan2(centerY - c1.y, centerX - c1.x));
           vArrow2.transformArrow(c2.x, c2.y, 10 * radius * omega * Math.cos(omega * time), -Math.PI / 2);
           aArrow2.transformArrow(c2.x, c2.y, 250 * radius * omega * omega * Math.sin(omega * time), Math.PI / 2);
           
           if(isPlaying) time++;
        }
        
        private function onClick(e:MouseEvent):void {
           isPlaying = !isPlaying; 
        }

    }
}

import flash.display.Graphics;
import flash.display.Shape;
import flash.geom.Matrix;

class Circle extends Shape{
    public function Circle(color:uint) {
        var g:Graphics = graphics;
        g.lineStyle(2);
        g.beginFill(color);
        g.drawCircle(0,0,10);
        
    }
    
}

class Arrow extends Shape {
    public function Arrow(color:uint) {
        var g:Graphics = graphics;
        g.lineStyle(5,color);
        g.moveTo(0, 10);
        g.lineTo(100, 10);
        g.lineTo(70, 5);
        g.moveTo(100, 10);
        g.lineTo(70, 15);
    }

    public function transformArrow(x1:Number, y1:Number, length:Number, angle:Number):void {
        var m:Matrix = new Matrix();
        m.translate(0, -10);
        m.scale(length / 100, length / 50);
        m.rotate(angle);
        m.translate(x1, y1);
        transform.matrix = m;
    }

}
