/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6yjJ
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
            var num:int;
            var i:int;
            
            num = mwidth * mheight;
            vecGrid = new Vector.<int>(num, false);
            
            for (i = 0; i < num; i++)
            {
                vecGrid[i] = Math.random()+0.2;
            }//nexti
            
            vecGrid[8*16 + 8] = 0;
            
            
            num = zwidth*zheight;
            vecZone = new Vector.<int>(num, false);
            for (i = 0; i < num; i++)
            {
                vecZone[i] = 0;
            }//nexti
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var mwidth:int = 16;
        public var mheight:int = 16;
        public var cw:Number = 16;
        public var ch:Number = 16;
        public var vecGrid:Vector.<int>;
        
        public var zwidth:int = 4;
        public var zheight:int = 4;
        public var zw:Number = 64;
        public var zh:Number = 64;
        public var vecZone:Vector.<int>;
        
        public var curFrame:int = 0;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            
            var i:int;
            var k:int;
            var yt:int;
            var t:int;
            
            for (i = 0; i < mheight; i++)
            {
                yt = i * mwidth;
                for (k = 0; k < mwidth; k++)
                {
                    t = vecGrid[k+yt];
                    if (t <= 0) { continue; }
                    graphics.beginFill(0, 1);
                    graphics.drawRect(k*cw,i*ch, cw,ch);
                    graphics.endFill();
                }//nextk
            }//nexti
            
            curFrame += 1;
            
            var mx:Number;
            var my:Number;
            var tx:Number;
            var ty:Number;
            var ox:Number;
            var oy:Number;
            var ang:Number;
            var sx:Number;
            var sy:Number;
            
            ox = mwidth*0.5 * cw;
            oy = mheight * 0.5 * ch;
            mx = stage.mouseX;
            my = stage.mouseY;
            
            ang = Math.atan2(my-oy, mx-ox);
            
            tx = Math.floor(mx/cw);
            ty = Math.floor(my/ch);
            
            sx = Math.cos(ang);
            sy = Math.sin(ang);
            
            graphics.lineStyle(2, 0xFF0000);
            
            var w:int;
            
            var ew:Number;
            var eh:Number;
            ew = mwidth * cw;
            eh = mheight * ch;
            
            tx = Math.floor(ox/cw); 
            ty = Math.floor(oy/ch);
            for (k = 0; k < 64; k++)
            {
                tx += sx;
                ty += sy;
                if (tx < 0) { break; }
                if (ty < 0) { break; }
                if (tx > ew) { break; }
                if (ty > eh) { break; }
                
                t = vecGrid[ (ty|0)*mwidth + (tx|0)];
                if (t > 0) { break; }
                
                w = (((ty/4)|0)*zwidth) + ((tx/4)|0);
                vecZone[w] = curFrame;
                
                graphics.drawCircle(tx*cw, ty*ch, 4);
                
            }//nextk
            
            for (i = 0; i < zheight; i++)
            {
                yt = i * zwidth;
                for (k = 0; k < zwidth; k++)
                {
                    t = vecZone[yt+k];
                    if (t != curFrame) { continue; }
                    
                    graphics.drawRect(k*zw, i*zh, zw, zh);
                    
                }//nextk
            }//nexti
            
            
            
            
        }//onenter
        
    }//classend
}