/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6yhS
 */

//数値として視覚化
//たぶん、Bitmapとか、Matrixとかで、もっと面白く出来るはずですが、技術の限界。

package 
{
    import flash.display.Sprite;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    
    import flash.text.AntiAliasType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    import flash.utils.ByteArray;
    
    [SWF(width=465,height=465,backgroundColor=0x000000)]
    public class Main extends Sprite
    {
        private var rot:Number = 0;
        
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        
        private var LRarr:Array = [];
        
        private var FFTswitcher:Boolean = true;
        
        
        public function Main():void 
        {
            Wonderfl.capture_delay(1);
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 5);
            LRarr = draw();
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.CLICK, FFTSwitch);
        }
        
        private function FFTSwitch(e:MouseEvent):void 
        {
            if (FFTswitcher) { FFTswitcher = false } else { FFTswitcher = true; }
        }
        
        private function loop(event:Event):void 
        {
            var tx:TextField = new TextField();
            var tf:TextFormat = new TextFormat();
            
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, FFTswitcher, 0);
            
            for (var n:int = 0; n < 2; n++)
            {
                var txArray:Array = LRarr[n];
                for (var i:int = 0; i < 256; i++)
                {
                    tx = txArray[i];
                    tx.autoSize = TextFieldAutoSize.LEFT;
                    tx .text = "";
                    var data:Number = bytes.readFloat();
                    var str:String = data.toFixed(5);
                    var pattern:RegExp =/[-.]/;
                    str = str.replace(pattern, "");
                    if (data < 0)
                    {
                        str = str.replace(pattern, "");
                        tf.color = 0xAAAAAA;
                        tx.defaultTextFormat = tf;
                        tx.text = str;
                    }
                    else
                    {
                        tf.color = 0xFFFFFF;
                        tx.defaultTextFormat = tf;
                        tx.text = str;
                    }
                    tx.scaleX = tx.scaleY = 1 + data * 1.2;
                    
                }
            }
        }
        
        private function draw():Array
        {
            var master_arr:Array = [];
            
            for (var n:int = 0; n < 2; n++)
            {
                var lr_arr:Array = [];
                for (var i:int = 0; i < 8; i++)
                {
                    for (var j:int = 0; j < 32; j++)
                    {
                        var tx:TextField = new TextField();
                        var tf:TextFormat = new TextFormat();
                        tx.antiAliasType = AntiAliasType.ADVANCED;
                        tf.color = 0xFFFFFF;
                        tf.size = 9;
                        tx.defaultTextFormat = tf;
                        tx.text = "0";
                    
                        tx.x = 465 / 16 * i + 232 * n;
                        tx.y = 465 / 32 * j;
                        addChild(tx);
                        lr_arr.push(tx);
                    }
                    
                }
                master_arr.push(lr_arr);
            }
            return master_arr;
        }
        
    }
    
}