/**
 * Copyright DanYuya ( http://wonderfl.net/user/DanYuya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6yQP
 */

// forked from DanYuya's Shooter Game 基本形
// シューティングゲーム
package {
    // 使用するパッケージをインポートする
    import fl.controls.*;
    import flash.text.*;
    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
        
    public class ShooterGame extends Sprite {
        public var timer:Timer;        // タイマー
        public var enemyTimer:Timer;   // タイマー（その２）
        public var myCombat:Sprite;    // 自機
        public var myBullet:Array;     // 弾丸（複数）
        public var vy:Array;           // 弾丸の速度（y方向）
        public var enemy:Sprite;       // 敵機
        public var theta:Number = 0.0;       // 敵機の位相
        public var hitFlag:Boolean = false;  // 衝突判定
        public var compBubble:Array;     // バブル（複数）
        public var bubbleVelocity:Array; // バブルの速度（y方向）
        public var tf:TextFormat;      // ラベル
        public var fld:TextField;      // ラベル
        
        public function ShooterGame() {
            // 配列（Array型）のインスタンス生成
            myBullet = new Array();
            vy = new Array();
            compBubble = new Array();
            bubbleVelocity = new Array();
            
            // Sprite 型の自機グラフィックスの生成
            myCombat = new Sprite();
            myCombat.graphics.beginFill( 0x99CC00, 1.0 );
            myCombat.graphics.drawRect( -2, 0, 4, 10 );
            myCombat.graphics.beginFill( 0x99CC00, 1.0 );
            myCombat.graphics.drawRect( -6, 2, 12, 2 );
            myCombat.graphics.beginFill( 0x99CC00, 1.0 );
            myCombat.graphics.drawRect( -3, 8, 6, 2 );
            myCombat.x = stage.mouseX;
            myCombat.y = stage.stageHeight - 50;
            stage.addChild( myCombat );
            
            // 敵機の生成
            enemy = new Sprite();
            enemy.graphics.beginFill( 0x000099, 1 );
            enemy.graphics.drawCircle( 0, 0, 10 );
            enemy.graphics.beginFill( 0x000099, 1 );
            enemy.graphics.moveTo(   0,  0 );
            enemy.graphics.lineTo( -20, 10 );          
            enemy.graphics.lineTo( +20, 10 );          
            //enemy.graphics.lineTo(   0,  0 );
            enemy.graphics.beginFill( 0x990099, 1 );
            enemy.graphics.drawCircle( -10, 10, 3 );          
            enemy.graphics.beginFill( 0x990099, 1 );
            enemy.graphics.drawCircle( +10, 10, 3 );         
            enemy.x = stage.stageWidth / 2;
            enemy.y = 50;
            stage.addChild( enemy );
            
            // マウス操作に関するイベントハンドラの登録
            stage.addEventListener( MouseEvent.MOUSE_MOVE, mMove );
            stage.addEventListener( MouseEvent.CLICK, mClick );
            
            // タイマーに関するイベントハンドラの登録とタイマーの開始
            timer = new Timer( 50 );
            timer.addEventListener( TimerEvent.TIMER, loop );
            timer.start();
            
            // 敵機の攻撃に関するタイマー
            enemyTimer = new Timer( 3000 );
            enemyTimer.addEventListener( TimerEvent.TIMER, attack );
            enemyTimer.start();
        }

        public function mMove( event:MouseEvent ): void{
            // 自機の位置をマウスの位置（x座標）に合わせる
            myCombat.x = stage.mouseX;
        }

        public function mClick( event:MouseEvent ): void{
            // 弾丸のグラフィックスを生成する
            var bullet:Sprite = new Sprite();
            bullet.graphics.beginFill( 0xFFFF00, 1.0 );
            bullet.graphics.drawCircle( 0, 0, 5 );
            bullet.graphics.beginFill( 0xFFFF00, 0.5 );
            bullet.graphics.drawCircle( 0, 4, 4 );
            bullet.graphics.beginFill( 0xFFFF00, 0.25 );
            bullet.graphics.drawCircle( 0, 8, 3 );
            bullet.x = myCombat.x;
            bullet.y = myCombat.y - 10;
            myBullet.push( bullet );    // 弾丸を配列 myBullet に追加する
            vy.push( -10 );   // 弾丸の y 方向の速度
            stage.addChild( myBullet[myBullet.length - 1] );
        }

        public function loop( event:TimerEvent ): void{
            // 全ての弾丸について
            for( var i:int = 0; i < myBullet.length; i++ ){
                // 位置の計算
                myBullet[i].y += vy[i];
                
                // 衝突の判定
                if( enemy.x - 10 < myBullet[i].x && myBullet[i].x < enemy.x + 10 && enemy.y - 10 < myBullet[i].y && myBullet[i].y < enemy.y + 10 ){
                    hitFlag = true;
                }
            }
            
            // 敵機の移動
            if( !hitFlag ){
                theta += 0.05;
                if( theta > 2 * Math.PI ){
                    theta -= 2 * Math.PI;
                }
                enemy.x = 0.5 * stage.stageWidth * ( 1 + Math.sin( theta ) );
            }
            else{
                // 弾丸に当たったら
                if( enemy.alpha > 0 ){
                    enemy.alpha -= 0.05; // フェードアウト
                }
                else{
                    // 終了処理
                    stage.removeChild( enemy );
                    stage.removeEventListener( MouseEvent.MOUSE_MOVE, mMove );
                    stage.removeEventListener( MouseEvent.CLICK, mClick );
                    timer.stop();
                    enemyTimer.stop();
                    
                    // ゲーム終了ラベルの表示
                     tf = new TextFormat();
                     tf.align = "center";
                     tf.font = "Times New Roman";
                     tf.size = 16;
                     tf.color = 0xFF0000;
                    
                     fld = new TextField();
                     fld.defaultTextFormat = tf;
                     fld.text = "Game Over";
                     fld.x = stage.stageWidth / 2 - 60;
                     fld.y = stage.stageHeight / 2 - 16;
                     fld.width = 120;
                     stage.addChild( fld );
                }
            }
            
            // バブルの移動
            for( var j:int; j < compBubble.length; j++ ){
                compBubble[j].y += bubbleVelocity[j];
            }
        }
        
        public function attack( event:TimerEvent ): void{
            // 敵機から放出されるバブル砲の処理
            var bubble:Sprite = new Sprite();
            bubble.graphics.beginFill( 0xFFCCCC, 0.5 );
            bubble.graphics.drawCircle( 0, 0, 10 );
            bubble.x = enemy.x;
            bubble.y = enemy.y + 10;
            compBubble.push( bubble );   // 敵機から放出されるバブルを配列 compBubble に追加する
            bubbleVelocity.push( +5 );   // バブルの y 方向の速度
            stage.addChild( compBubble[compBubble.length - 1] );
        }
    }
}