/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6yHD
 */

// forked from dkgkAs's サイン・コサインを使った円運動
/**
 * サイン・コサインを使った円運動
 * http://d.hatena.ne.jp/ActionScript/20090412/as3_math_sin_cos
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	[SWF(width = 465, height = 465, backgroundColor = 0xffffff, frameRate = 30)]
	
	public class Main extends Sprite 
	{
		private var _scx:Number;
		private var _scy:Number;
		
		private var _angle:Number = 0; // 角度
		private var _change:Number = 1; // 増やす角度
		private var _radius:Number = 150; // 半径
		private var _ball:Sprite;
		private var _gsp:Sprite; // ガイド
		private var _tf:TextField;
		
		private var _flag:Boolean = true;
		
		public function Main():void 
		{
			_scx = stage.stageWidth * 0.5;
			_scy = stage.stageHeight * 0.5;
			
			setup();
			
			this.stage.addEventListener(Event.ENTER_FRAME, draw);
			this.stage.addEventListener(MouseEvent.CLICK, goAndStop);
		}
		
		private function setup():void
		{
			var circle:Sprite = new Sprite();
			circle.graphics.lineStyle(1, 0x0, 1);
			circle.graphics.drawCircle(0, 0, _radius);
			circle.graphics.beginFill(0x0, 1);
			circle.graphics.drawCircle(0, 0, 3);
			circle.graphics.endFill();
			circle.x = _scx;
			circle.y = _scy;
			circle.alpha = 0.3;
			this.stage.addChild(circle);
			
			var line:Sprite = new Sprite();
			line.graphics.lineStyle(1, 0x0, 1);
			line.graphics.moveTo(_scx, 0);
			line.graphics.lineTo(_scx, stage.stageHeight);
			line.graphics.moveTo(0, _scy);
			line.graphics.lineTo(stage.stageWidth, _scy);
			line.alpha = 0.3;
			this.stage.addChild(line);
			
			_ball = new Sprite();
			_ball.graphics.beginFill(0x336699, 0.7);
			_ball.graphics.drawCircle(0, 0, 7);
			_ball.graphics.endFill();
			_ball.x = _scx + _radius;
			_ball.y = _scy;
			this.stage.addChild(_ball);
			
			_gsp = new Sprite();
			this.stage.addChild(_gsp);
			
			var tfmt:TextFormat = new TextFormat("Arial", 12, 0x0);
			_tf = new TextField();
			_tf.defaultTextFormat = tfmt;
			_tf.autoSize = TextFieldAutoSize.LEFT;
			this.stage.addChild(_tf);
		}
		
		private function goAndStop(event:MouseEvent):void 
		{
			
			if (_flag)
			{
				this.stage.removeEventListener(Event.ENTER_FRAME, draw);
			} else 
			{
				this.stage.addEventListener(Event.ENTER_FRAME, draw);
			}
			
			_flag = !_flag;
		}
		
		private function draw(event:Event):void 
		{
			// 円運動の計算
			var radian:Number = _angle * Math.PI / 180; // 度をラジアンに変換
			_ball.x = _scx + _radius * Math.cos(radian);
			_ball.y = _scy + _radius * Math.sin(radian);
			_angle += _change;
			_angle %= 360;
			
			// 以下ガイドの描画
			_gsp.graphics.clear();
			
			// 斜辺(半径)
			_gsp.graphics.lineStyle(2, 0x00ff00, 1);
			_gsp.graphics.moveTo(_scx, _scy);
			_gsp.graphics.lineTo(_ball.x, _ball.y);
			
			// 対辺
			_gsp.graphics.lineStyle(2, 0xff0000, 1);
			_gsp.graphics.moveTo(_ball.x, _ball.y);
			_gsp.graphics.lineTo(_ball.x, _scy);
			
			// 隣辺
			_gsp.graphics.lineStyle(2, 0x0000ff, 1);
			_gsp.graphics.moveTo(_ball.x, _scx);
			_gsp.graphics.lineTo(_scx, _scy);
			
			// 数値表示
			_tf.text = "画面クリックで再生/停止\n\n"
					 + "角度: " + _angle + "\n"
					 + "隣辺: " + _radius * Math.cos(radian) + " px\n"
					 + "対辺: " + _radius * Math.sin(radian) + " px\n\n"
					 + "ラジアン: " + radian + "\n"
					 + "コサイン: " + Math.cos(radian) + "\n"
					 + "サイン: " + Math.sin(radian) + "\n\n"
					 + "半径: " + _radius + " px\n";
		}
		
	}
	
}