/**
 * Copyright tnRaro ( http://wonderfl.net/user/tnRaro )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/6xT9
 */

// forked from tnRaro's flash on 2014-12-16
package {
    import com.adobe.images.PNGEncoder;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.Timer;
    import flash.utils.ByteArray;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.net.FileReference;
    
    public class Main extends Sprite {
        private var sx:int;
        private var sy:int;
        
        private var world:BitmapData;
        private var bitmap:Bitmap;
        
        private var timer:Timer;
        
        private var mx:int;
        private var my:int;
        
        private var ps:Vector.<Poi>;
        
        private var file:FileReference;
        
        public function Main() {
            resize(null);
            
            file = new FileReference();
            
            stage.addEventListener(Event.RESIZE, resize);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, me);
            
            stage.addEventListener(MouseEvent.CLICK, me);
            stage.addEventListener(MouseEvent.RIGHT_CLICK, me);
            
            world = new BitmapData(sx, sy, false, 0);
            bitmap = new Bitmap(world);
            
            ps = new Vector.<Poi>();
            
            addChild(bitmap);
            
            timer = new Timer(25);
            timer.addEventListener(TimerEvent.TIMER, te);
            timer.start();
            
            mx = sx*.5;
            my = sy*.5;
            
            var l:int=10000;
            var i:int=l;
            while( i --> 0 ){         
                ps.push(new Poi(Math.random()*sx*.5, Math.random()*sy, 0x571008));
            }
            i = l;
            while( i --> 0 ){         
                ps.push(new Poi(sx*.5+Math.random()*sx*.5, Math.random()*sy, 0x081057));
            }
        }
        
        private function me(e:MouseEvent):void{
            mx = e.stageX;
            my = e.stageY;
            
            if(e.type == 'click'){
                var l:int = ps.length*.5;
                var i:int = l*2;
                while( i --> l ){     
                    ps[i].init(Math.random()*sx*.5, Math.random()*sy, 0x571008);
                }
                i = l;
                while( i --> 0 ){         
                     ps[i].init(sx*.5+Math.random()*sx*.5, Math.random()*sy, 0x081057);
                }
                world.fillRect(world.rect, 0);
            }else
            if(e.type == 'rightClick'){
                var png:ByteArray = PNGEncoder.encode(world);
                
                file.save(png, '무제2_screenshot.png');
            }
        }
        
        public function pow(x:Number):Number{
            return x*x;
        }
        
        public function te(e:TimerEvent):void{
            //world.fillRect(world.rect, 0);
            
            var l:int = ps.length;
            for(var i:int=0;i<l;i++){
                var p:Poi = ps[i];
                
                var t:Number = Math.atan2(my-p.y, mx-p.x);
                var d:Number = (pow(mx-p.x)+pow(my-p.y));
                if(d < 1000) d = 1000000;
                var n:Number = 10000/d;
                
                p.vx += Math.cos(t) * n;
                p.vy += Math.sin(t) * n;
                
                p.x += p.vx * .8;
                p.y += p.vy * .8;
                
                world.setPixel(p.x, p.y, add(world.getPixel(p.x, p.y), p.color));
            }
        }
        
        private function add(p:int, v:int):int{
            var r:int = Math.min(0xff, (p>>16&0xff) + (v>>16&0xff));
            var g:int = Math.min(0xff, (p>>8&0xff) + (v>>8&0xff));
            var b:int = Math.min(0xff, (p&0xff) + (v&0xff));
            return (r<<16^g<<8^b);
        }
        
        public function resize(e:Event):void{
            sx = stage.stageWidth;
            sy = stage.stageHeight;
        }
    }
}
    
    class Poi{
        public var x:Number;
        public var y:Number;
        public var vx:Number;
        public var vy:Number;
        public var color:int;
        
        public function Poi(_x:int, _y:int, c:int){
            init(_x, _y, c);
        }
        
        public function init(a:int, b:int, c:int):void{
            x = a;
            y = b;
            vx = 0;
            vy = 0;
            
            color = c;
        }
    }