/**
 * Copyright nijitaro ( http://wonderfl.net/user/nijitaro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6xRA
 */

/**
 * PaperVision3D × Movie
 * 
 * BitmapData.draw()がセキュリティサンドボックスに引っかかるのでYouTubeを諦める。
 * 普通にFLV読むことにしたのでVideoStreamMaterialに変更。
 *
 * 元動画
 * http://www.youtube.com/user/NIJITAR0#p/u/13/W4_zeLrYr9c
 */
package {
    import flash.display.*;
    import flash.events.*;
    
    import flash.geom.Rectangle;
    
    import flash.media.Video;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    
    import flash.system.Security;
    
    import org.papervision3d.materials.VideoStreamMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    [SWF(backgroundColor="0xffffff", frameRate="50")]
    
    /* --------------------------------------------------
    [MEMO]
        SpriteではなくBasicViewをextendsする。BasicViewはSpriteのサブクラス
    -------------------------------------------------- */
    public class PV3DYouTube extends BasicView {		
		// Planeを使う
        private var plane:Plane;
		private var video:Video;
		private var nc:NetConnection;
		private var ns:NetStream;
		private var meta:Object;

        // コンストラクタ
        public function PV3DYouTube ()
        {
        	Security.loadPolicyFile("http://hokypoky.info/crossdomain.xml");
        	video = new Video(478,359);

        	nc = new NetConnection();
        	nc.connect(null);

        	ns = new NetStream(nc);
			ns.play("http://hokypoky.info/samples/10/01/video.flv");
			
			var client:Object = new Object();
			client.onMetaData = metaDataHandler;
			ns.client = client;
			meta = new Object;
			
			video.attachNetStream(ns);
			
			// materialをMovieMaterialから作成
        	var material:VideoStreamMaterial = new VideoStreamMaterial(video, ns, true, false);
        	// マテリアルの描画領域を指定する
        	material.rect = new Rectangle(0,0,478,359);
			// 両面にテクスチャを貼る
        	material.doubleSided = true;
        	// テクスチャの歪み防止
            material.precise = true;
			
			// 新規Planeオブジェクトを作成
            plane = new Plane( material, 478, 359, 16, 16 );
            
            // scene(予めBasicViewで定義されている表示エリア)に作成したplaneを追加する
            scene.addChild(plane);
            
            // cameraのズームを指定
            camera.zoom = 80;
            
            // BasicViewの描画を開始する
            startRendering();
        }
        private function metaDataHandler (data:Object):void {
        	meta = data;
        }
        private function onLoaderComplete (event:Event):void
        {
        	
        }
        
        /* --------------------------------------------------
        [MEMO]
            BasicViewのEvent.ENTER_FRAMEのようなもの。
            これをoverrideしてフレーム毎の挙動を定義する。
        -------------------------------------------------- */
        override protected function onRenderTick (event :Event = null):void
        {
            /* --------------------------------------------------
            [MEMO]
                Papervision3dは左手座標系。
                左手をGoodの状態(親指を立てる)にして
                親指を正の方向に向けた際の、4本指指の巻き方向がそれぞれ回転方向となる
            -------------------------------------------------- */
            // Y軸回転はyaw
            plane.yaw(0.1);
            // アハ体験
            camera.zoom -= 0.02;
            /* --------------------------------------------------
            [MEMO]
                BasicViewのonRenderTickも実行する。
                これがないと、onRenderTickが単純に上書きされてしまうので、
                もともともonRenderTickの機能を果たさない。
            -------------------------------------------------- */
            super.onRenderTick(event);
        }
    }
}