/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6xOD
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
 
	public class Main extends Sprite
	{
		private var player:Sprite;
		private var left:Boolean = false;
		private var right:Boolean = false;
		private var jump:Boolean = false;
		private var vy:int = 0;
 
		private const RADIUS:int = 20;
		private const SPEED:Number = 10;
 
		public function Main()
		{
			player = new Sprite();
			player.graphics.beginFill(0x0);
			player.graphics.drawCircle(0, 0, RADIUS);
			player.graphics.endFill();
			player.x = 200;
			player.y = stage.stageHeight - RADIUS;
			addChild(player);
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
 
		private function onEnterFrame(event:Event):void
		{
			if (jump)
			{
				vy += 2;
				player.y += vy;
 
				if (player.y + RADIUS > stage.stageHeight)
				{
					player.y = stage.stageHeight - RADIUS;
					jump = false;
				}
			}
			if (left) player.x -= SPEED;
			if (right) player.x += SPEED;
		}
 
		private function onKeyDown(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) left = true;
			if (event.keyCode == 39) right = true;
			if (event.keyCode == 38)
			{
				jump = true;
				vy = -20;
			}
		}
 
		private function onKeyUp(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) left = false;
			if (event.keyCode == 39) right = false;
		}
	}
}
