/**
 * Copyright techx ( http://wonderfl.net/user/techx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6xLb
 */

// forked from mousepancyo's Dot Goldfish2 
// forked from mousepancyo's Dot Goldfish（金魚） 
/*
Dot Goldfish2（金魚）

ProjectNyaさんのPerlinNoiseクラスをお借りして
水面の質感を変えてみました。
PerlinNoise : http://wonderfl.net/c/xuya

マウスダウンで1匹追加。（フィルタ処理が重いため50匹が限度です）
マウスをしばらくダウンしたままにすると集まってきます。

*/

package  {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BitmapDataChannel
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    
    public class Main extends Sprite{
        
        private static const DOT_NUM:uint = 100
        private var _container:Sprite = new Sprite()
        private var _bmd:BitmapData
        private var _bm:Bitmap
        private var _dotList:Vector.<Dot> = new Vector.<Dot>()
        private var _isClicked:Boolean
        
        private var _rippleBmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0)
        private var _perlinBmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF)
        private var _perlinOfset:Array = [new Point(0,0), new Point(0,0)];
        
        private var _noise:PerlinNoise;
        private var _speeds:Array;

        public function Main() {
            _bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF)
            _bm = new Bitmap(_rippleBmd, "auto", true)
            addChild(_bm)
            var channels:uint = BitmapDataChannel.RED | BitmapDataChannel.BLUE;
            _perlinBmd.perlinNoise(10, 10, 2, 1, true, false, channels, true, _perlinOfset);
            //
            for(var i:int; i<DOT_NUM; i++){
                addDot(int(Math.random() * stage.stageWidth), int(Math.random() * stage.stageHeight))
            }
            //
            water()
            //
            addEventListener(Event.ENTER_FRAME, update)
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown)
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp)
        }
        
        private function water():void {
            var octaves:uint = 2;
            //
            _noise = new PerlinNoise(_bmd.rect, 16, 16, octaves);
            //
            _speeds = new Array();
            for (var n:uint = 0; n < octaves; n++) {
                var sx:Number = (Math.random() - 0.5)*2 + 2;
                var sy:Number = (Math.random() - 0.5)*3;
                _speeds.push(new Point(sx, sy));
            }
        }
        
        private function addDot($startX:Number, $startY:Number):void{
            var dot:Dot = new Dot(stage.stageWidth, stage.stageHeight)
            dot.x = $startX
            dot.y = $startY
            _container.addChild(dot)
            _dotList.push(dot)
        }
        
        private function update(e:Event):void{
            if(!_isClicked){
                for(var i:int; i<_dotList.length; i++){
                    hitCheck(_bmd, _dotList[i])
                }
            }
            //
            _bmd.lock()
            _bmd.colorTransform(_bmd.rect, new ColorTransform(.98, .25, .22, 3, 0, 0, 0, 0));
            _bmd.draw(_container)
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(0,0), new BlurFilter(4,3,1))
            _bmd.unlock()
            //
            ripple()
        }
        
        private function onDown(e:MouseEvent):void{
            _isClicked = true
            if(_dotList.length < 50) addDot(mouseX, mouseY)
            for(var i:int; i<_dotList.length; i++){
                _dotList[i]._p.x = mouseX
                _dotList[i]._p.y = mouseY
            }
        }
        
        private function onUp(e:MouseEvent):void{
            _isClicked = false
        }
        
        private function hitCheck(bmd:BitmapData, dot:Dot):void{
            var n:int
            for(var i:int=-10; i<10; i++){
                for(var j:int=-10; j<10; j++){
                    if(bmd.getPixel(dot.x+j, dot.y+i) != 0xFFFFFF){
                        n++
                    }
                }
            }
            if(n > 250 && n < 300){
                dot.stopTween()
            }
        }
        
        private function ripple():void {
            var dmf:DisplacementMapFilter = new DisplacementMapFilter(_noise, new Point(0, 0), 1, 1, 8, 8, "clamp");
            _noise.update(_speeds);
            _rippleBmd.lock()
            _rippleBmd.draw(_bmd)
            _rippleBmd.draw(_perlinBmd, null, new ColorTransform(.25, .1, 1, .3, 10, 80, 0, 0))
            _rippleBmd.draw(_noise, null, new ColorTransform(1, .1, 1, 0.75), "screen")
            _rippleBmd.unlock()
            _bm.filters = [dmf];
        }

    }
}

//class Dot
import flash.display.Sprite;
import flash.geom.Point;
import fl.motion.easing.*;
import com.flashdynamix.motion.*;
import flash.display.BitmapData;


class Dot extends Sprite{
    
    private var _w:int
    private var _h:int
    public var _p:Point
    private var _speed:Number
    private var _tween:TweensyGroup
    
    public function Dot(w:int, h:int){
        _w = w
        _h = h
        _p = new Point(int(Math.random() * (_w * 1.2) - (_w * .1)),int(Math.random() * (_h * 1.2) - (_h * .1)));
        //
        var r:int = int(Math.random() * 8 + 248) << 16
        var g:int = int(Math.random() * 8 + 127) << 8
        var b:int = int(Math.random() * 8 + 88)
        var col:int = r + g + b
        graphics.beginFill(col)
        graphics.drawCircle(0,0,Math.floor(Math.random() * (25 - 1 + 1)) + 1);
        graphics.endFill()
        //
        tween(Math.random() * 5 + 5, _p.x, _p.y)
    }
    
    private function tween(time:Number, xPos:Number, yPos:Number=0, delay:Number=0):void {
        _p = new Point(int(Math.random() * (_w * 1.2) - (_w * .1)),int(Math.random() * (_h * 1.2) - (_h * .1)));
        _tween = new TweensyGroup();
        _tween.to(this, {x:xPos, y:yPos}, time, Linear.easeOut, delay);
        _tween.onComplete = tweenComplete;
        function tweenComplete():void {
            _tween.dispose();
            _tween = null;
            tween(Math.random() * 5 + 5, _p.x, _p.y)        
        }
    }

    public function stopTween():void{
        _tween.stop(this)
        _tween.dispose();
        _tween = null;
        tween(Math.random() * 1 + 2, _p.x, _p.y)
    }
}


/*
ProjectNyaさんのPerlinNoiseクラス
http://wonderfl.net/c/xuya
*/

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;

class PerlinNoise extends BitmapData {
    private var bx:uint;
    private var by:uint;
    private var octaves:uint;
    private var seed:uint;
    private var stitch:Boolean = true;
    private var fractalNoise:Boolean = true;
    private var channel:uint = 0;
    private var grayScale:Boolean = false;
    private var offsets:Array = new Array();

    public function PerlinNoise(rect:Rectangle, x:uint, y:uint, o:uint = 1, g:Boolean = true, c:uint = 0, s:uint = 1, st:Boolean = false, f:Boolean = true) {
        super(rect.width, rect.height, false, 0xFF000000);
        bx = x;
        by = y;
        octaves = o;
        grayScale = g;
        channel = c;
        if (grayScale) channel = 0;
        for (var n:uint = 0; n < octaves; n++) {
            var point:Point = new Point();
            offsets.push(point);
        }
        stitch = st;
        fractalNoise = f;
        create(s, offsets);
    }

    private function create(s:uint, o:Array = null):void {
        seed = s;
        offsets = o;
        if (offsets == null) offsets = [new Point()];
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }
    public function update(speeds:Array):void {
        for (var n:uint = 0; n < octaves; n++) {
            var offset:Point = offsets[n];
            var speed:Point = speeds[n];
            offset.x += speed.x;
            offset.y += speed.y;
        }
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }
}