/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6x9C
 */

package 
{
    import flash.display.MovieClip;
    /**
     * ...
     * @author kiyo
     */
    public class MVCsampleMain extends MovieClip
    {
        private var view:RectObj;
        private var controller:Controller;
        private var model:Model;
        
        public function MVCsampleMain() 
        {
            model = new Model();
            controller = new Controller();
            controller.model = model;
            view = new RectObj(model);
            view.x = 100;
            view.y = 100;
            controller.x = 200;
            controller.y = 200;
            addChild(view);
            addChild(controller);
        }
    }

}

import flash.events.Event;
    import flash.events.EventDispatcher;
    /**
     * ...
     * @author kiyo
     */
    class Model extends EventDispatcher
    {
        private var _rotation:Number;
        private var _color:uint;
        private var rectVisible:Boolean;
        private var circleVisible:Boolean;
        
        public function Model() 
        {
            _rotation = 0;
            _color = 0;
        }
        
        public function setProperty(rotation:Number,color:uint):void
        {
            _rotation = rotation;
            _color = color;
            dispatchEvent(new Event(Event.CHANGE));
        }
        
        public function get rotation():Number { return _rotation; }
        
        public function get color():uint { return _color; }
        
        
        
    }
    
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     * @author kiyo
     */
    class View extends Sprite
    {
        protected var _model:Model;
        
        public function View(model:Model) 
        {
            _model = model;
            _model.addEventListener(Event.CHANGE, updateModel);
            draw();
        }
        
        protected function draw():void
        {
            
        }
        
        private function updateModel(e:Event):void 
        {
            update();
        }
        
        protected function update():void
        {
            //サブクラスで実装
        }
        
    }
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    class Controller extends Sprite
    {
        private var _model:Model;
        
        public function Controller() 
        {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 40, 20);
            graphics.endFill();
            buttonMode = true;
            addEventListener(MouseEvent.CLICK, clickHandler);
        }
        
        private function clickHandler(e:MouseEvent):void 
        {
            _model.setProperty(360 * Math.random(), 0xffffff * Math.random());
        }
        
        public function set model(value:Model):void 
        {
            _model = value;
            _model.addEventListener(Event.CHANGE, updateModel);
        }
        
        private function updateModel(e:Event):void 
        {
            
        }
        
    }
    
    class RectObj extends View
    {
        private var color:uint;
        
        public function RectObj(model:Model) 
        {
            color = 0xff0000;
            super(model);
        
        }
        
        override protected function draw():void 
        {
            graphics.clear();
            graphics.beginFill(color);
            graphics.drawRect(0, 0, 30, 30);
            graphics.endFill();
        }
        
        override protected function update():void 
        {
            this.rotation = _model.rotation;
            this.color = _model.color;
            draw();
            
        }
        
    }