/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6wRc
 */

package {
  import com.actionscriptbible.Example;
  
  public class ch12ex8 extends Example {
    public function ch12ex8() {
      //USING REGULAR EXPRESSION FLAGS
      
      contactsSnippetWithoutMultiline();
      contactsSnippetWithMultiline();
      dotallSnippet();
      extendedSnippet();
    }
    protected function contactsSnippetWithoutMultiline():void {
      var contacts:Object = new Object();
      var contactText:String = 
          "Call us at one of these numbers.\n" +
          "Los Angeles: 310-555-2910\n" + 
          "New York: 212-555-2499\n" + 
          "Boston: 617-555-7141";
      var officeAndPhone:RegExp = /^([\w\s]+): (\d{3}-\d{3}-\d{4})/;
      
      var lines:Array = contactText.split(/\n/);
      var line:String;
      for each (line in lines) {
          var result:Array = line.match(officeAndPhone);
          if (result) {
              contacts[result[1]] = result[2];
          }
      }
    }
    protected function contactsSnippetWithMultiline():void {
      var contacts:Object = new Object();
      var contactText:String = 
          "Call us at one of these numbers.\n" +
          "Los Angeles: 310-555-2910\n" + 
          "New York: 212-555-2499\n" + 
          "Boston: 617-555-7141";
      var officeAndPhone:RegExp = /^([\w\s]+): (\d{3}-\d{3}-\d{4})/gm;
      
      var result:Object;
      while (result = officeAndPhone.exec(contactText)) {
          contacts[result[1]] = result[2];
      }
    }
    protected function dotallSnippet():void {
      var lines:String = "hello,\n cruel world!";
      trace(lines.match(/hello.*world/)); //null
      trace(lines.match(/hello.*world/s)); //hello,
                                           // cruel world
    }
    protected function extendedSnippet():void {
      //find these complete words which rhyme with base: space, trace, race.
      var rhymes:RegExp = /\b  (tr|r|sp|b) a (c|s) e  \b/gix;
    }
  }
}