/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6vse
 */

/*
フレンドパーク的な何か
キーボードの←,→で操作
クリア条件はありません
*/

package {
import Box2D.Dynamics.*;
import Box2D.Collision.*;
import Box2D.Collision.Shapes.*;
import Box2D.Common.Math.*;
import Box2D.Dynamics.Joints.*;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.display.*;

[SWF(backgroundColor="#FFFFFF")]
public class Test extends Sprite {
    private const SCALE:Number = 10;
	private const SHIFT:Number = 70;
	private const OFFSETX:Number = 65;
    private var world:b2World;
	private var objBdDef:b2BodyDef = new b2BodyDef();
	private var RevJoint1:b2RevoluteJoint;
	private var RevJoint2:b2RevoluteJoint;
	private var RevJoint3:b2RevoluteJoint;
	private var JointDef1:b2RevoluteJointDef;
	private var JointDef2:b2RevoluteJointDef;
	private var JointDef3:b2RevoluteJointDef;
	private var StartFlag:Boolean = true;

    // コンストラクタ
    public function Test() {
        stage.scaleMode = "noScale";
        stage.align = "TL";
		
        // 初期化
        init();
		
        // 毎フレームの処理
        var count:int = 0;
        addEventListener("enterFrame", function(event:Event):void {
            world.Step(1 / 9, 10);
            if ( StartFlag ) {
				StartFlag = false;
                createObject();
            }
			
            // 下に行ったオブジェクトを削除する
            for (var b2bdy:b2Body = world.GetBodyList(); b2bdy; b2bdy = b2bdy.GetNext()) {
                var sprite:Sprite = b2bdy.GetUserData() as Sprite;
                if (sprite){
                    sprite.x = b2bdy.GetWorldCenter().x * SCALE;
                    sprite.y = b2bdy.GetWorldCenter().y * SCALE;
                    sprite.rotation = b2bdy.GetAngle() * 180 / Math.PI;
					
                    if (sprite.y > 600){
                        world.DestroyBody(b2bdy);
                        removeChild(sprite);
						StartFlag = true;
                    }
                }
            }
        });
		
		stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
    }
	
	private function KeyDown(event:KeyboardEvent):void {
		//Left
		if (event.keyCode == 37) {
			JointDef1.motorSpeed = JointDef2.motorSpeed = JointDef3.motorSpeed = 0.2;
			JointDef1.enableMotor = JointDef2.enableMotor = JointDef3.enableMotor = true;
			world.DestroyJoint(RevJoint1);
			world.DestroyJoint(RevJoint2);
			world.DestroyJoint(RevJoint3);
			RevJoint1 = world.CreateJoint(JointDef1) as b2RevoluteJoint;
			RevJoint2 = world.CreateJoint(JointDef2) as b2RevoluteJoint;
			RevJoint3 = world.CreateJoint(JointDef3) as b2RevoluteJoint;
		}
		//Right
		else if (event.keyCode == 39) {
			JointDef1.motorSpeed = JointDef2.motorSpeed = JointDef3.motorSpeed = -0.2;
			JointDef1.enableMotor = JointDef2.enableMotor = JointDef3.enableMotor = true;
			world.DestroyJoint(RevJoint1);
			world.DestroyJoint(RevJoint2);
			world.DestroyJoint(RevJoint3);
			RevJoint1 = world.CreateJoint(JointDef1) as b2RevoluteJoint;
			RevJoint2 = world.CreateJoint(JointDef2) as b2RevoluteJoint;
			RevJoint3 = world.CreateJoint(JointDef3) as b2RevoluteJoint;
		}
	};


    // 初期化
    private function init():void {
        //----------------------------------
        // 世界を作成する
        //----------------------------------
        // シミュレーションする座標の範囲を指定する
        var worldAABB:b2AABB = new b2AABB();
        worldAABB.lowerBound.Set(-100.0, -100.0);
        worldAABB.upperBound.Set(100.0, 100.0);
        // 重力を定義する
        var gravity:b2Vec2 = new b2Vec2(0.0, 9.8);
        // 世界のインスタンスを作成する
        world = new b2World(worldAABB, gravity, true);
		
        //----------------------------------
        // 床を作る
        //----------------------------------
        // 形の定義を作る
        var wallShapeDef:b2PolygonDef = new b2PolygonDef();
        wallShapeDef.SetAsBox(180 / SCALE, 10 / SCALE);
		wallShapeDef.density = 100.0;

		//下
        var wallBdDef:b2BodyDef = new b2BodyDef();
        wallBdDef.position.Set( ( 400 + SHIFT + OFFSETX ) / 2 / SCALE, 300 / SCALE);
        var wallBd1:b2Body = world.CreateBody(wallBdDef);
		//中
        wallBdDef.position.Set( ( 400 - SHIFT + OFFSETX ) / 2 / SCALE, 200 / SCALE);
        var wallBd2:b2Body = world.CreateBody(wallBdDef);
		//上
        wallBdDef.position.Set( ( 400 + SHIFT + OFFSETX ) / 2 / SCALE, 100 / SCALE);
        var wallBd3:b2Body = world.CreateBody(wallBdDef);
		
		drawFloor( wallBd1, wallShapeDef );
		drawFloor( wallBd2, wallShapeDef );
		drawFloor( wallBd3, wallShapeDef );
		
		//----------------------------------
        // 支点を作る
        //----------------------------------
        // 形の定義を作る
		var fulcrumShapeDef:b2CircleDef = new b2CircleDef();
		fulcrumShapeDef.radius = 5 / SCALE;
		//下
		var fulcrumBdDef1:b2BodyDef = new b2BodyDef();
        fulcrumBdDef1.position.Set( ( 400 + SHIFT + OFFSETX ) / 2 / SCALE, 300 / SCALE );
        var fulcrumBd1:b2Body = world.CreateBody(fulcrumBdDef1);
		//中
		var fulcrumBdDef2:b2BodyDef = new b2BodyDef();
        fulcrumBdDef2.position.Set( ( 400 - SHIFT + OFFSETX ) / 2 / SCALE, 200 / SCALE );
        var fulcrumBd2:b2Body = world.CreateBody(fulcrumBdDef2);
		//上
		var fulcrumBdDef3:b2BodyDef = new b2BodyDef();
        fulcrumBdDef3.position.Set( ( 400 + SHIFT + OFFSETX ) / 2 / SCALE, 100 / SCALE );
        var fulcrumBd3:b2Body = world.CreateBody(fulcrumBdDef3);
		
		drawFulcrum( fulcrumBd1, fulcrumShapeDef );
		drawFulcrum( fulcrumBd2, fulcrumShapeDef );
		drawFulcrum( fulcrumBd3, fulcrumShapeDef );
		
		//----------------------------------
        // 杭を作る
        //----------------------------------
		var pileShapeDef:b2CircleDef = new b2CircleDef();
		pileShapeDef.radius = 5 / SCALE;
		
		var pileBdDef:b2BodyDef = new b2BodyDef();
        var pileBd:b2Body = world.CreateBody(pileBdDef);
		pileBd.CreateShape(pileShapeDef);
		
		createPile( (400 + SHIFT + OFFSETX + 100) / 2 / SCALE, (300 + 30) / SCALE, pileShapeDef, pileBdDef, pileBd );
		createPile( (400 + SHIFT + OFFSETX - 100) / 2 / SCALE, (300 + 30) / SCALE, pileShapeDef, pileBdDef, pileBd );
		createPile( (400 - SHIFT + OFFSETX + 100) / 2 / SCALE, (200 + 30) / SCALE, pileShapeDef, pileBdDef, pileBd );
		createPile( (400 - SHIFT + OFFSETX - 100) / 2 / SCALE, (200 + 30) / SCALE, pileShapeDef, pileBdDef, pileBd );
		createPile( (400 + SHIFT + OFFSETX + 100) / 2 / SCALE, (100 + 30) / SCALE, pileShapeDef, pileBdDef, pileBd );
		createPile( (400 + SHIFT + OFFSETX - 100) / 2 / SCALE, (100 + 30) / SCALE, pileShapeDef, pileBdDef, pileBd );
		
		//----------------------------------
        // ジョイントを作る
        //----------------------------------
		//ジョイントを作成
		JointDef1 = new b2RevoluteJointDef();
		//アンカーポイントを設定
		JointDef1.Initialize(wallBd1, fulcrumBd1, new b2Vec2( ( 400 + SHIFT + OFFSETX )/ 2 / SCALE, 300 / SCALE ));
		JointDef1.maxMotorTorque = 1000000;//モータのトルク
		
		//ジョイントを作成
		JointDef2 = new b2RevoluteJointDef();
		//アンカーポイントを設定
		JointDef2.Initialize(wallBd2, fulcrumBd2, new b2Vec2( ( 400 - SHIFT + OFFSETX ) / 2 / SCALE, 200 / SCALE ));
		JointDef2.maxMotorTorque = 1000000;//モータのトルク
		
		//ジョイントを作成
		JointDef3 = new b2RevoluteJointDef();
		//アンカーポイントを設定
		JointDef3.Initialize(wallBd3, fulcrumBd3, new b2Vec2( ( 400 + SHIFT + OFFSETX ) / 2 / SCALE, 100 / SCALE ));
		JointDef3.maxMotorTorque = 1000000;//モータのトルク
		
		//実体化	
		RevJoint1 = world.CreateJoint(JointDef1) as b2RevoluteJoint;
		RevJoint2 = world.CreateJoint(JointDef2) as b2RevoluteJoint;
		RevJoint3 = world.CreateJoint(JointDef3) as b2RevoluteJoint;
		
    }

    // 物体を１個作る
    private function createObject():void{
        objBdDef.position.Set((300 + OFFSETX) / SCALE, 0);
		
        var objBd:b2Body = world.CreateBody(objBdDef);
		var circ:b2CircleDef = new b2CircleDef();
		circ.radius = 5 / SCALE;
        circ.density = 5;
        circ.restitution = 0.1;
        circ.friction = 10;
        objBd.CreateShape(circ);
        objBd.SetMassFromShapes();
        var sprite:Sprite = createSprite();
        sprite.x = sprite.y = -9999;
        addChild(sprite);
        objBd.m_userData = sprite;
    }

    // 物体の Sprite を作成する
    private function createSprite():Sprite{
        var ret:Sprite = new Sprite();
        ret.graphics.beginFill(0xFF);
        ret.graphics.drawCircle(0, 0, 5);
        ret.graphics.endFill();
        return ret;
    }
	
	// 床を描く
	private function drawFloor( wallBd:b2Body, wallShapeDef:b2PolygonDef ):void {
		wallBd.CreateShape(wallShapeDef);
		wallBd.SetMassFromShapes();
		var sprite:Sprite = new Sprite();
		sprite.graphics.beginFill(0xC0C0C0);
		sprite.graphics.drawRect(-180, -10, 360, 20);
		sprite.graphics.endFill();
		addChild(sprite);
		wallBd.m_userData = sprite;
	}
	
	//支点を描く
	private function drawFulcrum( fulcrumBd:b2Body, fulcrumShapeDef:b2CircleDef ):void {
		fulcrumBd.CreateShape(fulcrumShapeDef);
		var sprite:Sprite = new Sprite();
		sprite.graphics.beginFill(0xFFFFFF);
		sprite.graphics.drawCircle( 0, 0, fulcrumShapeDef.radius*SCALE );
		sprite.graphics.endFill();
		addChild(sprite);
		fulcrumBd.m_userData = sprite;
	}
		
	//杭を作る
	private function createPile( _x:Number, _y:Number, pileShapeDef:b2CircleDef, pileBdDef:b2BodyDef, pileBd:b2Body ):void {
		pileBdDef.position.Set( _x, _y );
		pileBd = world.CreateBody(pileBdDef);
		pileBd.CreateShape(pileShapeDef);
		var sprite:Sprite = new Sprite();
        sprite.graphics.beginFill(0xC0C0C0);
        sprite.graphics.drawCircle(0, 0, 5);
        sprite.graphics.endFill();
		addChild(sprite);
		pileBd.m_userData = sprite;
	}
}
}
