/**
 * Copyright dottohakinshi ( http://wonderfl.net/user/dottohakinshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6tzW
 */

// forked from paq's forked from: [Stardust] RendererにcopyPixelsを使う（向きのあるパーティクル版）
// forked from Nicolas's [Stardust] RendererにcopyPixelsを使う（向きのあるパーティクル版）
// forked from paq's [Stardust] RendererにcopyPixelsを使う
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import net.hires.debug.Stats;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    public class Main extends Sprite 
    {
        static private const COLOR_TRANSFORM:ColorTransform = new ColorTransform (0.9, 0.9, 0.95);
        private var _emitter:MyEmitter;
        private var _canvas:BitmapData;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _canvas = new BitmapData(465, 465, false, 0x000000);
            var bmp:Bitmap = new Bitmap(_canvas);
            addChild(bmp);
            
            var sp:Shape = new Shape();
            var g:Graphics = sp.graphics;
            //g.lineStyle(2, 0x333333);
            g.beginFill(0xFFFFFF, 0.5);
            g.moveTo(0, 5);
            g.lineTo(10, 5);
            g.lineTo(10, 0);
            g.lineTo(20, 10);
            g.lineTo(10, 20);
            g.lineTo(10, 15);
            g.lineTo(0, 15);
            g.lineTo(0, 5);

            //var particleBitmap:BitmapData = new BitmapData(20, 20, true, 0x00000000);
            //particleBitmap.draw(sp);
            
            _emitter = new MyEmitter(new SteadyClock(10));
            var renderer:DirectedCopyPixelsRenderer = new DirectedCopyPixelsRenderer(_canvas, sp);
            renderer.addEmitter(_emitter);
            
            stage.quality = StageQuality.LOW;
            
            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void 
        {
            _canvas.colorTransform(_canvas.rect, COLOR_TRANSFORM);
            _emitter.field.x = stage.mouseX;
            _emitter.field.y = stage.mouseY;
            _emitter.step();
        }
        
    }
    
}
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.geom.Point;
import flash.geom.Matrix;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.events.EmitterEvent;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.ParticleIterator;
import idv.cjcat.stardust.common.renderers.Renderer;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.particles.Particle2D;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;
import idv.cjcat.stardust.common.math.StardustMath;
import idv.cjcat.stardust.twoD.fields.RadialField;
import idv.cjcat.stardust.twoD.actions.Gravity;

class MyEmitter extends Emitter2D 
{
    public var field:RadialField;
    
    public function MyEmitter(clock:Clock)
    {
        super(clock)
        
        addInitializer(new Position(new SinglePoint(233, 233)));
        addInitializer(new Velocity(new LazySectorZone(3, 1)));
        addInitializer(new Life(new UniformRandom(100, 100)));
        
        field = new RadialField();
        field.strength = -1;
        var gravity:Gravity = new Gravity();
        gravity.addField(field);
        
        addAction(gravity);
        addAction(new Move());
        addAction(new Age());
        addAction(new DeathLife());
    }
}

class DirectedCopyPixelsRenderer extends Renderer
{
    public var targetBitmapData:BitmapData;
    public var sourceDisplayObject:DisplayObject;    
    public var sourceBitmapDataList:Array = [];    
    private var point:Point;
    
    public function DirectedCopyPixelsRenderer(targetBitmapData:BitmapData = null, sourceDisplayObject:DisplayObject = null)
    {
        this.targetBitmapData = targetBitmapData;
        this.sourceDisplayObject = sourceDisplayObject;
        
        var width:int = this.sourceDisplayObject.width;
        var height:int = this.sourceDisplayObject.height;
        var baseBitmapData:BitmapData = new BitmapData(width, height, true, 0x00000000);
        baseBitmapData.draw(sourceDisplayObject);
        sourceBitmapDataList[0] = baseBitmapData;
        var matrix:Matrix = new Matrix();
        for (var i:int = 1; i < 360; i++)
        {
            var bmd:BitmapData = new BitmapData(width, height, true, 0x00000000);
            matrix.translate(-width / 2, -height / 2);
            matrix.rotate(1 * StardustMath.DEGREE_TO_RADIAN);
            matrix.translate(width / 2, height / 2);
            bmd.draw(baseBitmapData, matrix);
            sourceBitmapDataList[i] = bmd;
        }
        point = new Point(); 
    }

    override protected function render(e:EmitterEvent):void
    {
        if (!targetBitmapData) return;
        
        targetBitmapData.lock();
        var particle:Particle2D;
        var rotation:int;
        var sourceImage:BitmapData
        var iter:ParticleIterator = e.particles.getIterator();
        while (particle = iter.particle as Particle2D)
        {
            point.x = particle.x;
            point.y = particle.y;
            rotation = int(Math.atan2(particle.vy, particle.vx) * StardustMath.RADIAN_TO_DEGREE);
            if (rotation < 0) rotation += 360;
            sourceImage = sourceBitmapDataList[rotation];
            targetBitmapData.copyPixels(sourceImage, sourceImage.rect, point);
            iter.next();
        }
        targetBitmapData.unlock();
    }
}