/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6tke
 */

package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.Security;
    import caurina.transitions.Tweener;
    
    [SWF(backgroundColor="#000000",width="465",height="465")]
    
    public class FlashTest extends Sprite {
        private var file:String = "http://assets.wonderfl.net/images/related_images/3/37/37f5/37f5f9a17dfa799dadba38e45e568d4da9b4ee23";
        private var base:Sprite;
        private var canvas:BitmapData;
        private var dots:Array;
        
        public function FlashTest() {
            init();
        }//FlashTest()
        
        private function init():void{
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            base = new Sprite();
            base.graphics.beginFill(0x000000);
            base.graphics.drawRect(0, 0, 465, 465);
            base.graphics.endFill();
            addChild(base);
            
            canvas = new BitmapData(465, 465, false, 0xffff0000);
            var bitmap:Bitmap = new Bitmap(canvas);
            addChild(bitmap);
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete, false, 0, true);
            loader.load(new URLRequest(file));
        }//init()
        
        private function onComplete(event:Event):void{
            var content:Bitmap = event.target.content;
            content.x=int((465 - content.width)/2);
            content.y=int((465 - content.height)/2);
            initalize(content);
        }//onCom;lete()
        
        private function initalize(bitmap:Bitmap):void{
            var bitmapData:BitmapData = bitmap.bitmapData;
            dots = new Array();
            canvas.lock();
            canvas.fillRect(canvas.rect, 0xff0000000);
            for(var i:int = 0; i < bitmap.width; i++) {
                for(var j:int = 0; j <bitmap.height; j++){
                    var tx:int = i * bitmap.x;
                    var ty:int = j * bitmap.y;
                    var dot:Dot = new Dot(tx, ty);
                    var color:uint = bitmapData.getPixel(i, j);
                    dot.color = color;
                    dots.push(dot);
                    
                }//for j
            }//for i
            canvas.setPixel(dot.x, dot.y, dot.color);  
            canvas.unlock();
            base.buttonMode = true;
            base.addEventListener(MouseEvent.CLICK, onClick, false, 0, true);  
        }//initalize()
        
        private function onClick(event:MouseEvent):void{
            base.mouseEnabled = false;
            base.useHandCursor = false;
            start();
        }//onClick
        
        private function start():void{
            for(var i:int = 0; i < dots.length; i++){
                var dot:Dot = dots[i];
                dot.x = uint(Math.random()*800) - 400 + 232;
                dot.y = uint(Math.random()*800) - 400 + 232;
                dot.completed = false;
            }//for
            addEventListener(Event.EXIT_FRAME, updata, false, 0, true);

        }//start()
        
        private function updata(event:Event):void{
            canvas.lock();
            canvas.fillRect(canvas.rect, 0xff0000ff);
            var completed:uint = 0;
            for(var i:int = 0; i < dots.length; i++){
                var dot:Dot = dots[i];
                dot.x += (dot.tx - dot.x)*0.2;
                dot.y += (dot.ty - dot.y)*0.2;
                canvas.setPixel(dot.x, dot.y, dot.color);
               // if(!dot.completed){
                    //canvas.setPixel(dot.x, dot.y, dot.color);
                //} else {
                //    completed ++;
                 //   if (completed > dots.length - 1) {
                        
                 //   }

                //}
                


            }//for
            canvas.unlock();

        }//updata


        




    }//claww
}//package

class Dot{
    public var x:Number = 0;
    public var y:Number = 0;
    public var tx:int = 0;
    public var ty:int = 0;
    public var color:uint;
    public var completed:Boolean = false;
    
    public function Dot(x:int, y:int) {
        tx = x;
        ty = y;
        
    }

}
