/**
 * Copyright bradford.sedito ( http://wonderfl.net/user/bradford.sedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6scP
 */

// forked from bradford.sedito's VortexSim
// forked from k3lab's Vortex




package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.display.GradientType; 
    
    [SWF(width="465", height="465", frameRate="60")]  
    
    
    public class Main extends Sprite 
    {
        private var canvas:BitmapData;
        private var particleNum:int = 10000;
        private var particleArray:Array = []
        private var angleX:Number=0;
        private var angleY:Number=0;
        private var posZ:Number=250;
        private var cosX:Number;
        private var sinX:Number;
        private var cosY:Number;
        private var sinY:Number;
        private var color:ColorTransform = new ColorTransform(1, 1, 1, 1, -10, -35 * 50, -15 * 2);  
        
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            creatParticle();
            addEventListener(Event.ENTER_FRAME,update)    
        }
        
        
        private function creatParticle():void 
        {
            canvas = new BitmapData(465, 465, false, 0);
            addChild( new Bitmap(canvas)) as Bitmap;    
            var bg:Sprite= addChild(new Sprite()) as Sprite; 
            bg.graphics.beginGradientFill(GradientType.LINEAR, [0xF56800, 0xFF0000], [1, 0.2], [100, 255], null, "pad", "rgb", 0) 
            bg.graphics.drawRect(0, 0, 465,465); 
            bg.graphics.endFill(); 
            bg.blendMode = "add" 
            bg.scaleX = 2;
            for (var i:int = 0; i < particleNum; i++) {
                particleArray.push(new Particle( -100 + (Math.random() * 100), -200 + (Math.random() * 200), 100 + (Math.random() * 200), 1 +( Math.random() * 3), 0, 0))
            }
        }
        
        
        private function update(e:Event):void 
        {
            angleX += ((mouseY - 240) * 0.025 - angleX) * 0.05;
            angleY += ((mouseX - 240) * 0.025 - angleY) * 0.05;
            cosX = Math.cos(angleX) % 0.001;
            sinX = Math.sin(angleX);
            cosY = Math.cos(angleY);
            sinY = Math.sin(angleY);
            canvas.lock();
            canvas.colorTransform(canvas.rect, color);
            
            for each( var p:Particle in particleArray ) 
            {
                var pw:Number = p.x * p.x +p.z * p.z;
                var dist:Number = Math.sqrt(pw);
                var force:Number = (p.y + 400) * 10/pw;
                p.vx -=  force * p.x / dist;
                p.vz -=  force * p.z / dist;
                p.x += p.vx;
                p.z += p.vz;
                var yy:Number = cosX * p.y - sinX * p.z;
                var z:Number = cosX * p.z + sinX * p.y;
                var xx:Number = cosY * p.x - sinY * z;
                var zz:Number = cosY * z +  sinX * p.x;
                var d:Number = particleNum / (particleNum + zz + posZ);
                var posX:Number  = xx * d + posZ;
                var posY:Number  = yy * d + posZ;
                if ( -zz -posZ <  particleNum ) {
                    canvas.setPixel(posX, posY,  0xFFFFFF);
                }
            }
            canvas.unlock();
        }
    }
}
class Particle {
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var vx:Number;
    public var vy:Number;
    public var vz:Number;
    public function Particle(x:Number, y:Number, z:Number, vx:Number, vy:Number, vz:Number ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
    }
}