/**
 * Copyright amashio ( http://wonderfl.net/user/amashio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6sO7
 */

package{
    
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    
    public class AbstractImageLoader extends Sprite {
        
        protected var _loadedBitmap:Bitmap;
        
        public function AbstractImageLoader(path:String) {
            loadImage(path);
        }
        
        private function loadImage(imagePath:String):void{
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
            loader.load(new URLRequest(imagePath));
        }
        
        private function onImageLoaded(event:Event):void{
            var loaderInfo:LoaderInfo = event.target as LoaderInfo;
            _loadedBitmap = loaderInfo.content as Bitmap;
            runPostImageLoad();
        }
        
        protected function runPostImageLoad():void{
            
        }
    }
    
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    
    public class ColorTransformTest extends AbstractImageLoader {
        
        private var _bitmap:Vector.<Bitmap>;
        
        public function ColorTransformTest() {
            super("../_asset/harbor.jpg");
        }
        
        override protected function runPostImageLoad():void{
            _bitmaps = new Vector.<Bitmap>();
            var imageSize:Number = stage.stageWidth/3;
            for(var row:uint = 0; row < 2; row++){
                for(var column:uint = 0; column < 3; column++){
                    createBitmap(column*imageSize, row*imageSize);
                }
            }
            var sourceData:BitmapData = _loadedBitmap.bitmapData;
            var matrix:Matrix = new Matrix();
            var scale:Number = imageSize/sourceData.width;
            matrix.scale(scale, scale);
            var copiedData:BitmapData = new BitmapData(sourceData.width*scale, sourceData.height*scale);
            copiedData.draw(sourceData, matrix);
            createVariations(copiedData);
            stage.addEventListener(MouseEvent.CLICK, onMouseClick);
        }
        
        private function createBitmap(x:Number, y:Number):void{
            var bitmap:Bitmap = new Bitmap();
            bitmap.x = x;
            bitmap.y = y;
            addChild(bitmap);
            _bitmaps.push(bitmap);
        }
        
        private function createVariations(original:BitmapData):void{
            var brighten:Number = 1.3;
            var darken:Number = 0.7;
            _bitmaps[0].bitmapData = original;
            _bitmaps[1].bitmapData = makeVariation(original, new ColorTransform(brighten, brighten, brighten));
            _bitmaps[2].bitmapData = makeVariation(original, new ColorTransform(darken, darken, darken));
            _bitmaps[3].bitmapData = makeVariation(original, new ColorTransform(brighten));
            _bitmaps[4].bitmapData = makeVariation(original, new ColorTransform(1, brighten));
            _bitmaps[5].bitmapData = makeVariation(original, new ColorTransform(1, 1, brighten));
            
        }
        
        private function makeVariation(original:BitmapData, transform:ColorTransform):BitmapData{
            var variation:BitmapData = original.clone();
            variation.colorTransform(variation.rect, transform);
            return variation;
        }
        
        private function onMouse(event:MouseEvent):void{
            for each(var bitmap:Bitmap in _bitmaps){
                if(bitmap.hitTestPoint(event.localX, event.localY)){
                    createVariations(bitmpa.bitmapData);
                    break;
                }
            }
        }
    }
}