/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6rLj
 */

//キーボード入力を表示

//スクリーンキャプチャ動画とか見ると
//キーボード入力が可視化されていたんで
//AIR+QuickTimeXで利用する事を想定して作ってみた．

//なんとなくそんな感じになったけど，
//Shiftとか押したら変になるし，なんかかっこう悪い・・・

package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    
    public class FlashTest extends Sprite {
        public var loader:Loader = new Loader();
        
        public function FlashTest() {
            Wonderfl.capture_delay(8);
            
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
            //背景画像の読込み
            this.addChild(loader);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/e/e9/e9fb/e9fb51bdaa89fb4a65241fefd11a2be6196bcc06"));

            var keyboard:KeyboardAction = new KeyboardAction(this);
        }
    }
}



import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.text.*;
import flash.events.KeyboardEvent;

class KeyboardAction extends Sprite{
    private var tf:TextField = new TextField();
    private var tfFormat:TextFormat = new TextFormat("Arial",20,0xffffff,null,null,null,null,null,TextFormatAlign.CENTER);
    private var input:Vector.<uint> = new Vector.<uint>();
    
    public function KeyboardAction(parent:DisplayObjectContainer = null){
        if(parent) parent.addChild(this);
        addChild(tf);
        this.y = stage.stageHeight-100;
        tf.width = stage.stageWidth;
        tf.defaultTextFormat = tfFormat;
        tf.mouseEnabled = false;
        stage.addEventListener(KeyboardEvent.KEY_DOWN, keyboardHandler);
        stage.addEventListener(KeyboardEvent.KEY_UP, keyboardHandler);
    }

    //KeyboardEventハンドラ
    private function keyboardHandler(event:KeyboardEvent):void{
        switch(event.type){
            case KeyboardEvent.KEY_DOWN: push(event.keyCode); break;
            case KeyboardEvent.KEY_UP: shift(event.keyCode);; break;
        }
        
        //キーボード入力の表示
        tf.text = "";
        for each(var val:uint in input){
            if(tf.length) tf.appendText(" ");
            tf.appendText(KEYBOARD_LIST[val] == "" ? String(val) : KEYBOARD_LIST[val]);
        }
        drawBackground();
    }
    
    //テキストの背景描画
    private function drawBackground():void{
        this.graphics.clear();
        if(!tf.length) return;
        this.graphics.lineStyle(2.5, 0xffffff, 0.8);
        this.graphics.beginFill(0x000000,0.5);
        //矩形の最小サイズ設定
        if(tf.length < 5) this.graphics.drawRoundRect((stage.stageWidth-75)/2,-5,75,40,15);
        else this.graphics.drawRoundRect((stage.stageWidth-tf.length*15)/2,-5,tf.length*15,40,15);
        this.graphics.endFill();
    }    
    
    //入力時
    private function push(val:uint):Vector.<uint>{
        //キーボードはずっと押してるとKEY_DOWNを送出し続ける
        if(input.indexOf(val) == -1) input.push(val);
        input.sort(sortFunction);
        return input;
    }
    
    //出力時
    private function shift(val:uint):Vector.<uint>{
        if(input.indexOf(val) > -1) input.splice(input.indexOf(val),1);
        input.sort(sortFunction);
        return input;
    }
    
    //ソート用関数
    private function sortFunction(x:uint, y:uint):int{
        if(x == y) return 0;
        if(x > y) return 1;
        return -1;
    }
    
    public static const KEYBOARD_LIST:Vector.<String> = Vector.<String>(["_", //0
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "BackSpace",
                                                                      "Tab",
                                                                      "", //10
                                                                      "",
                                                                      "Clear",
                                                                      "Enter",
                                                                      "",
                                                                      "",
                                                                      "Shift",
                                                                      "Ctrl",
                                                                      "Alt",
                                                                      "Pause",
                                                                      "CapsLock", //20
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "Esc",
                                                                      "",
                                                                      "",
                                                                      "", //30
                                                                      "",
                                                                      "Space",
                                                                      "PageUp",
                                                                      "PageDown",
                                                                      "End",
                                                                      "Home",
                                                                      "Left",
                                                                      "Up",
                                                                      "Right",
                                                                      "Down", //40
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "Insert",
                                                                      "Delete",
                                                                      "Help",
                                                                      "0",
                                                                      "1",
                                                                      "2", //50
                                                                      "3",
                                                                      "4",
                                                                      "5",
                                                                      "6",
                                                                      "7",
                                                                      "8",
                                                                      "9",
                                                                      "",
                                                                      "",
                                                                      "", //60
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "A",
                                                                      "B",
                                                                      "C",
                                                                      "D",
                                                                      "E",
                                                                      "F", //70
                                                                      "G",
                                                                      "H",
                                                                      "I",
                                                                      "J",
                                                                      "K",
                                                                      "L",
                                                                      "M",
                                                                      "N",
                                                                      "O",
                                                                      "P", //80
                                                                      "Q",
                                                                      "R",
                                                                      "S",
                                                                      "T",
                                                                      "U",
                                                                      "V",
                                                                      "W",
                                                                      "X",
                                                                      "Y",
                                                                      "Z", //90
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "0",
                                                                      "1",
                                                                      "2",
                                                                      "3",
                                                                      "4", //100
                                                                      "5",
                                                                      "6",
                                                                      "7",
                                                                      "8",
                                                                      "9",
                                                                      "*",
                                                                      "+",
                                                                      "Enter",
                                                                      "-",
                                                                      ".", //110
                                                                      "/",
                                                                      "F1",
                                                                      "F2",
                                                                      "F3",
                                                                      "F4",
                                                                      "F5",
                                                                      "F6",
                                                                      "F7",
                                                                      "F8",
                                                                      "F9", //120
                                                                      "F10",
                                                                      "F11",
                                                                      "F12",
                                                                      "F13",
                                                                      "F14",
                                                                      "F15",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //130
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //140
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "NumLock",
                                                                      "ScreenLock",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //150
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //160
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //170
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //180
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      ";",
                                                                      "^",
                                                                      ",",
                                                                      "-",
                                                                      ".", //190
                                                                      "/",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //200
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //210
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "@",
                                                                      "]", //220
                                                                      "[",
                                                                      ":",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "\\",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //230
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //240
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "", //250
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      "",
                                                                      ""]);
}