/**
 * Copyright satoru.net ( http://wonderfl.net/user/satoru.net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6r6O
 */

// forked from narutohyper's Color&Sound Button
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.text.*;
    import flash.media.*;
    import flash.net.*;
    import com.bit101.components.*;
    
    /**
     * ...
     * @author narutohyper
     */
    [SWF(width = 100, height = 100, frameRate = 60,backgroundColor=0x000000)]
    public class Main extends Sprite
    {
        
        private var _buttons:Vector.<switchButton> = new Vector.<switchButton>();
        private var _actionVector:Vector.<switchButton>
        private var _counter:uint=0
        private var _all:Boolean=false
        public var _label:TextField=new TextField()
//      private var _sound:mySound
        private var _voiceCounter:uint=0
        public var heeSound:Sound = new Sound();
        public var tf:TextField = new TextField();

        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0,0,465,465);
            removeEventListener(Event.ADDED_TO_STAGE, init);
            heeSound.load(new URLRequest("http://bit.ly/cdoynr"));

            //_sound=new mySound()

            addChild(tf);
            tf.selectable = false;
            updateCounter(0)

            var reset:PushButton = new PushButton(this,28,50,"reset",function():void{ updateCounter(0) })
            reset.setSize(45,14)


            var bt:switchButton = _buttons[0] = new switchButton(0);
                bt.x = 50;
                bt.y = 750;
                bt.z = 250;
                bt.addEventListener(switchButton.DOWN, onClick);
                addChild(bt);
            
            this.transform.perspectiveProjection.projectionCenter = new Point(stage.stageWidth / 2, stage.stageHeight / 2 - 300);

            _buttons[0].up();
            _actionVector = _buttons.slice();

            



        }
        
        private function updateCounter(count:int):void{
            _counter = count ? _counter+1 : 0;
            tf.text = String(_counter);

            tf.setTextFormat(new TextFormat("_self",30,0xFF0000));            
        }
        
        
        private function onClick(e:Event):void {
            if(_counter<20){
                updateCounter(1)
                heeSound.play();
            }
                _buttons[0].up()
        }
        
    }
    
}


import flash.display.Shape;
import flash.display.Sprite;
import flash.display.GradientType
import flash.events.MouseEvent;
import flash.events.Event;
import flash.geom.Matrix
import flash.geom.ColorTransform;

import flash.filters.BitmapFilter;
import flash.filters.BitmapFilterQuality;
import flash.filters.GlowFilter;
import flash.filters.BlurFilter;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITweenGroup;

import frocessing.color.ColorHSV;

class switchButton extends Sprite {
    public static const DOWN:String = 'down'
    private var _size:Number = 60
    private var _hall:Sprite = new Sprite();
    private var _bt:Sprite = new Sprite();
    private var _cylinder:Shape = new Shape();
    private var _msk:Shape = new Shape();
    private var _cap:Sprite = new Sprite()
    private var _top:Shape = new Shape();
    private var _light:Shape = new Shape();
    private var _id:uint = 0
    private var _ct:ColorTransform = new ColorTransform()
    private var _tg:ITweenGroup
//  private var _sound:mySound;
    private var _glowSize:Number=1

    
    public function switchButton(id:uint) {
        _id = id;
        
        makeShape(_cylinder)
        makeShape(_msk)

        _hall.graphics.beginFill(0x000000);
        _hall.graphics.drawEllipse(0, 0, _size, 30);
        _hall.graphics.endFill()

        _top.graphics.beginFill(0xFFFFFF);
        _top.graphics.drawEllipse(0, 0, _size, 30);
        _top.graphics.endFill()
        
        _light.graphics.beginFill(0xFFFFFF,0.8);
        _light.graphics.drawEllipse(0,-1, _size, 30);
        _light.graphics.endFill()

        var filter:BitmapFilter = getBlurFilter(5);
        var myFilters:Array = [filter];
        _light.filters = myFilters;
        

        
        //addChild(hall);
        addChild(_bt);
        addChild(_msk);
        _hall.scaleX=_hall.scaleY=1.4
        _hall.x = -_hall.width/2
        _hall.y = 57
        _cylinder.mask = _msk
        _bt.addChild(_cylinder);
        _msk.x = -_size / 2
        _bt.addChild(_cap);
        _cap.addChild(_top);
        _cap.addChild(_light);
        _bt.x=-_size/2
        _bt.y = 0
        _cap.alpha = 0
        //bt.cacheAsBitmap = true;

        visible = false;
        
        var hsv:ColorHSV = new ColorHSV();
        hsv.h = Math.floor(360 * 14 / 25);
        hsv.s = 1
        hsv.v = 1
        _ct.color = hsv.toRGB().value;
        _top.transform.colorTransform = _ct;


//      _sound.addEventListener(SiONTrackEvent.BEAT,onBeat)
        this.addEventListener(Event.ENTER_FRAME,onEnter)
    }


    
    
    public function onEnter(e:Event):void {
        if (visible) {
            _glowSize *= 0.9;
            var filter:BitmapFilter = getGlowFilter(_glowSize);
            var myFilters:Array = [filter];
            _top.filters = myFilters;
        }
    }
    
    
    public function get id():uint { return _id; }
    
    public function set id(value:uint):void
    {
        _id = value;
    }
    
    
    
    public function reset():void {
        if (_tg) {
            _tg.stop();
        }
        
        _bt.buttonMode = false;
        _bt.removeEventListener(MouseEvent.MOUSE_DOWN, onClick)

        var _t:Array
        _t=[]
        _t[0] = BetweenAS3.tween(_bt, { y: 60 }, null, 0.01, Circ.easeOut)
        _t[1] = BetweenAS3.tween(_cylinder, { alpha: 0}, null, 0.01, Circ.easeOut)
        _t[1] = BetweenAS3.tween(_cap, { alpha: 0}, null, 0.01, Circ.easeOut)
        _tg = BetweenAS3.serialTweens(_t)
        _tg.addEventListener(TweenEvent.COMPLETE, onComplete);
        _tg.play();
        
        function onComplete(e:TweenEvent):void {
            _tg.removeEventListener(TweenEvent.COMPLETE, onComplete);
            visible = false;
            dispatchEvent(new Event(DOWN))
        }

    }
    
    public function up():void {
        visible = true;
        //_bt.y=60
        //_top.alpha = 0.5;
        //cylinder.alpha = 0;
        if (_tg) {
            _tg.stop();
        } else {
            _cap.alpha = 0
            _cylinder.alpha=0
        }
        
        
        var _t:Array
        _t=[]
        _t[0] = BetweenAS3.tween(_cap, { alpha: 1 }, null, 0.05, Circ.easeOut)
        _t[1] = BetweenAS3.tween(_cylinder, { alpha: 1 }, null, 0.01, Circ.easeOut)
        _t[2] = BetweenAS3.tween(_bt, { y: 30 }, null, 0.05, Circ.easeOut)
        _tg = BetweenAS3.serialTweens(_t)
        _tg.addEventListener(TweenEvent.COMPLETE, onComplete);
        _tg.play();
        
        function onComplete(e:TweenEvent):void {
            _tg.removeEventListener(TweenEvent.COMPLETE, onComplete);
            _bt.buttonMode = true;
            _bt.addEventListener(MouseEvent.MOUSE_DOWN, onClick)
        }
    }
    
    private function onClick(e:MouseEvent):void {
//      _sound.noteOn(id)
        reset();
    }
    
    
    private function makeShape(bt:Shape):void {
        var fillType:String = GradientType.LINEAR;
        var colors:Array = [0xCCCCCC,0xFFFFFF, 0x666666, 0x999999];
        var alphas:Array = [1, 1, 1, 1];
        var ratios:Array = [0x00,0x22, 0xAA,0xFF];
        var matr:Matrix = new Matrix();
        

        matr.createGradientBox(_size, _size, 0, 0, 0);
        bt.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr);
        bt.graphics.drawRect(0, 15, _size, _size);
        bt.graphics.endFill()
        bt.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr);
        bt.graphics.drawEllipse(0, _size, _size, 30);
        bt.graphics.endFill()
        bt.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr);
        bt.graphics.drawEllipse(0, 0, _size, 30);
        bt.graphics.endFill()
    }
    

    private function getGlowFilter(no:Number=1):BitmapFilter {
            var color:Number = 0x33CCFF;
            var alpha:Number = 0.8;
            var blurX:Number = 35*no;
            var blurY:Number = 25*no;
            var strength:Number = 2;
            var inner:Boolean = false;
            var knockout:Boolean = false;
            var quality:Number = BitmapFilterQuality.HIGH;

            return new GlowFilter(color,alpha,
                                                        blurX,blurY,
                                                        strength,quality,
                                                        inner,knockout);
    }
    
    private function getBlurFilter(no:Number=1):BitmapFilter {
            var blurX:Number = 3.5*no;
            var blurY:Number = 2.5*no;
            var quality:Number = BitmapFilterQuality.HIGH;

            
            return new BlurFilter(blurX,blurY,quality);
    }

    
}
