/**
 * Copyright zendenmushi ( http://wonderfl.net/user/zendenmushi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6qyY
 */

// hypocycloid in hypocycloid
// いいパターンが現れないか試行錯誤中。エディットボックスなどをつけてパラメータを変更
// できるようにすべきだけど手抜き。初期パターンはinit()で定義している。
// それ以降のパターンはマウスクリックのたびに自動生成
package  
{
	import flash.display.Bitmap;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import frocessing.core.F5BitmapData2D;
	/**
	 * ...
	 * @author TMaeda
	 */
    [SWF(width=465,height=465,backgroundColor=0,frameRate=60)]
	public class Hypocycloid extends Sprite
	{
		private var canvas : F5BitmapData2D;
		private var bmp : Bitmap;
		private var lineCanvas : F5BitmapData2D;
		private var lineBmp : Bitmap;
		private var colorTrans : ColorTransform = new ColorTransform(0.8, 0.8, 0.99, 0.99);
		private var lineColorTrans : ColorTransform = new ColorTransform(0.5, 0.5, 0.6, 0.9);
		private var pos : Point = new Point();
		private var rad : Number = 0;
		private var r : Vector.<Number> = new Vector.<Number>;
		private var mat : Matrix = new Matrix();
		private var befpos : Point = null;
		
		
		public function Hypocycloid() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event=null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			canvas = new F5BitmapData2D(stage.stageWidth, stage.stageHeight, true, 0xff000000);
			bmp = new Bitmap(canvas.bitmapData);
			addChild(bmp);
			canvas.noFill();
			canvas.strokeWeight(0.5);
			canvas.stroke(0x80, 0x80, 0x80, 0x80);

			lineCanvas = new F5BitmapData2D(stage.stageWidth, stage.stageHeight, true, 0x80000000);
			lineBmp = new Bitmap(lineCanvas.bitmapData);
			lineCanvas.blendMode = BlendMode.HARDLIGHT;
			addChild(lineBmp);
/* // Flashアイコン風
			r.push(180);// 一番外周の円の半径
			r.push(60);// その中の円の半径。外側の円よりも大きくても良い
			r.push(30);// 最後の要素は円からどれくらい飛び出した位置から軌跡を書くかを指定。通常は0
*/
 // 2重の内サイクロイド
			r.push(180); // 一番外周の円の半径
			r.push(60);  // その中の円の半径。外側の円よりも大きくても良い
			r.push(25);  // さらにその中の円の半径。外側の円よりも・・以下略
			r.push(50);  // 最後の要素は円からどれくらい飛び出した位置から軌跡を書くかを指定。通常は0

			addEventListener(Event.ENTER_FRAME, enterFrame);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		
		private function onClick(e:MouseEvent):void 
		{
                        //クリックの度に条件をランダム生成。円の個数を変えてもよいが、
                        //パラメータをランダムに選んでいるので、1つのパターンができるまでの周期が長く
                        //なりがちなので2重でやめておく
			lineCanvas.bitmapData.colorTransform(lineCanvas.bitmapData.rect, lineColorTrans);
			r[0] = 180;
			r[1] = Math.random() * r[0];
			r[2] = Math.random() * r[1];
			r[3] = Math.random() * 10;
			befpos = null;
		}
		
		private function enterFrame(e:Event):void 
		{
			var x : Number, y : Number, px : Number, py : Number, radx : Number;
			
			pos.x = 0;
			pos.y = 0;
			canvas.bitmapData.colorTransform(canvas.bitmapData.rect, colorTrans);
			canvas.beginDraw();
			
			px = stage.stageWidth / 2;
			py = stage.stageHeight / 2;
			var cnt : int = r.length;
			var r0 : Number = r[0];
			var r1 : Number, r2 : Number;
			var sign : int = 1;
			radx = 0;// rad;
			canvas.circle(px, py, r0);
			for (var i : int = 1; i < cnt-1; i++) {
				radx += rad*sign;
				r1 = r[i];
				px = px + Math.cos(radx) * (r0 - r1);
				py = py + Math.sin(radx) * (r0 - r1) * sign;

				radx = rad * (r0 - r1) / r1;
				if (i == cnt - 2) r2 = r[i + 1]; else r2 = 0;
				x = px + Math.cos(radx) * (r1+r2);		
				y = py - Math.sin(radx) * (r1+r2);
				canvas.moveTo(px, py);
				canvas.lineTo(x, y);

				r0 = r1;
				sign = -1 * sign;
				canvas.circle(px, py, r0);
			}
			canvas.endDraw();
			
			if (!befpos) {
				befpos = new Point();
				befpos.x = x;
				befpos.y = y;
			} 
			

			lineCanvas.noFill();
			lineCanvas.stroke(0xff*Math.abs(Math.cos(rad)), 0xff*Math.abs(Math.sin(rad)), 0x40, 0x80);
			lineCanvas.strokeWeight(4);
			lineCanvas.beginDraw();
			lineCanvas.moveTo(befpos.x, befpos.y);
			lineCanvas.lineTo(x, y);
			lineCanvas.endDraw();
			
			befpos.x = x;
			befpos.y = y;
		
			rad += 2*Math.PI / 180;
			
		}
		
	}

}