/**
 * Copyright tonka ( http://wonderfl.net/user/tonka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6qVT
 */

// forked from gurumi's forked from: パーティクル練習
// forked from yanbaka's パーティクル練習
// ブームが終わった頃に練習
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	
	public class ParticlePractice extends Sprite
	{
		private const HAJIKERO:uint = 20; // はじけ具合
		
		private var _particles:Array;
		private var _canvas:BitmapData;
		
		public function ParticlePractice()
		{
			init();
		}
		
		private function init():void
		{
			_particles = [];
			_canvas = new BitmapData(465, 465, true, 0x0);
			this.addChild(new Bitmap(this._canvas)) as Bitmap;
			
			this.stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			this.stage.addEventListener(Event.ENTER_FRAME, enterframeHandler);
		}
		
		private function mouseMoveHandler(e:MouseEvent):void 
		{
			var i:int = 600;
			while (i--) createParticle();
		}
		
		private function createParticle():void {
			var p:Particle = new Particle();
			p.x = stage.mouseX;
			p.y = stage.mouseY;
			var radius:Number = Math.sqrt(Math.random())*HAJIKERO;
			var angle:Number = Math.random()*(Math.PI)*2;
			p.vx = Math.cos(angle) * radius;
			p.vy = Math.sin(angle) * radius;
			p.c = 0xFFFFFFFF*Math.random();
			_particles.push(p);
		}
		
		private function enterframeHandler(e:Event):void
		{
			update();
		}
		
		private function update():void {
			this._canvas.lock();
			this._canvas.fillRect(this._canvas.rect, 0x0);
			var i:int = _particles.length;
			while (i--) {
				var p:Particle = _particles[i];
				p.vy += 0.3;
				p.vx *= .9;
				p.vy *= .9;
				p.x += p.vx;
				p.y += p.vy;
				this._canvas.setPixel32(p.x, p.y, p.c);
				if ((p.x > stage.stageWidth || p.x < 0) || (p.y < 0 || p.y > stage.stageHeight) || Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01)
				{
					this._particles.splice(i, 1);
				}
			}
			this._canvas.unlock();
		}
		
	}
	
}

class Particle
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var c:uint;
	
	public function Particle()
	{
		this.x = 0;
		this.y = 0;
		this.vx = 0;
		this.vy = 0;
		this.c = 0xFFFFFFFF;
	}
}

