/**
 * Copyright takun336 ( http://wonderfl.net/user/takun336 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6qUd
 */

// forked from agenda23's plane2 とちゅう
package 
{
	import flash.display.*;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.utils.*;
	import flash.ui.*;
	import flash.text.*;
	
	import flash.geom.*;
    import flash.filters.*;
	import flash.events.*;
	import flash.system.System;
	
	
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.cameras.*;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.materials.shaders.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.proto.LightObject3D;
	import org.papervision3d.core.proto.MaterialObject3D;
	
	import net.hires.debug.Stats;
	import com.flashdynamix.motion.*;
	import com.flashdynamix.motion.easing.*;
	import fl.motion.easing.*;
	
	//import org.flashdevelop.utils.FlashConnect;
	
	[SWF(width="640", height="480", backgroundColor="0xFFCC00", frameRate="60")] 
	
	/**
	 * ...
	 * @author mi55ile
	 */
	
	 public class Main extends Sprite 
	{
		private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var myObj:Plane;
        private var myObj2:Sphere;
		
		//event_values
		private var val:Number = 7;
		private var segments:Number;
		private var t_clock:Number = 420;
		private var bpm_double:Number = 260;
		private var bpm:Number = 130;
		private var tf:TextField;
		private var str:String;
		private var timer:Timer;
				
		//materials
		private var mat_flag:Boolean = true;
		private var colorMat:ColorMaterial;
		private var blackMat:ColorMaterial;
		private var wireMat:WireframeMaterial;
		private var wireMat2:WireframeMaterial;
		private var compoMat:CompositeMaterial;
		private var gouraudMat:GouraudMaterial;
		
		//other
		private var mousePointer:MousePointer;
		private var tg:TweensyGroup;
				
				
		
		public function Main():void 
			{       
                                Mouse.hide();
				stage.align = StageAlign.TOP_LEFT;
				stage.scaleMode = StageScaleMode.NO_SCALE;
				stage.quality = StageQuality.LOW;
				init3D();
				addChild(new Stats( { bg: 0x1A1A1A } ));

				
				mousePointer = new MousePointer();
				addChild(mousePointer);
				Mouse.hide();
				stage.addEventListener(MouseEvent.MOUSE_MOVE, function(event:MouseEvent):void {
				mousePointer.x = stage.mouseX;
				mousePointer.y = stage.mouseY;
				mousePointer.visible = true;
				event.updateAfterEvent();
				});
				
				tf = new TextField(); 

				var tform:TextFormat = new TextFormat();
				tform.size = 9;
				stage.addChild(tf);
				tf.defaultTextFormat = tform;
				tf.x = 5;
				tf.y = 120;
				tf.width  = 100;
				tf.height = 20;
				tf.textColor = 0x08FF10;
				tf.multiline = true;
				tf.type = TextFieldType.DYNAMIC;
				tf.text = "";
				
				
			//BPM選択(↑↓キー)
			function keyDownHandler2(event:KeyboardEvent):void {
				 if (event.keyCode == Keyboard.UP) {
					if (360 > bpm_double) {
									bpm_double ++;
									bpm = bpm_double / 2;
									}
					tg = new TweensyGroup();
					tg.alphaTo(tf,1,0.1);
					tf.text = "BPM : " + String(bpm);
					tg.alphaTo(tf,0,3);
					
					
					
					//FlashConnect.trace(bpm);
				 } else if (event.keyCode == Keyboard.DOWN) {
					if (140 < bpm_double) {
									bpm_double --;
									bpm = bpm_double / 2;
									}
					tf.text = "BPM : " + String(bpm);
					//FlashConnect.trace(bpm);
				 } 
			t_clock = (60000 / bpm ) ;
			timer.reset();
			timer.delay = t_clock;
			timer.start();
			
			//FlashConnect.trace(t_clock);
			event.updateAfterEvent();  
			}
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler2);				
				
				
			}
			
			private function init3D():void
			{
				viewport = new Viewport3D(0,0,true);
				viewport.opaqueBackground = 0x000000;
				addChild(viewport);

				renderer = new BasicRenderEngine();

				camera = new Camera3D();
				camera.target = myObj;
				camera.z = -450;
				camera.focus = 500;
				camera.zoom = 1;
				
				var light:LightObject3D = new LightObject3D();  
				light.x = 1000;  
				light.y = 1000;  
				light.z = 0;  

				scene = new Scene3D();
		
				colorMat = new ColorMaterial( 0x808080, 1 );
				blackMat = new ColorMaterial( 0x000000, 1 );
				wireMat = new WireframeMaterial( 0x08FF10 );
				wireMat2 = new WireframeMaterial( 0x000000 );
				gouraudMat = new GouraudMaterial(light, 0x08FF10, 0x08FF10);
				
				compoMat = new CompositeMaterial();
				compoMat.addMaterial(blackMat);
				compoMat.addMaterial(wireMat);
				compoMat.doubleSided = true;
				segments = 15;
				myObj = new Plane(compoMat,300,300,segments,segments);
				scene.addChild(myObj);		
				
				timer = new Timer(t_clock );
				timer.addEventListener(TimerEvent.TIMER,timer_handler);
				timer.start();
				
				addEventListener (Event.ENTER_FRAME, onEnterFrame); 
				stage.addEventListener (MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
				stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
				renderer.renderScene(scene, camera, viewport);
				}
				
			//keyboard event
			private function keyDownHandler (event:KeyboardEvent):void {
				if (event.keyCode == 82) {
					if (mat_flag == true) {
						 mat_flag = false;
						 compoMat.removeAllMaterials();
						 compoMat.addMaterial(gouraudMat);
						 compoMat.addMaterial(wireMat2);
					}else{
						 mat_flag = true;
						 compoMat.removeAllMaterials();
						 compoMat.addMaterial(blackMat);
						 compoMat.addMaterial(wireMat);
					}
				}else if (event.keyCode == 219) {
					if (segments <= 20) {
						scene.removeChild(myObj);
						segments += 1;
						myObj = new Plane(compoMat, 300, 300, segments, segments);
						scene.addChild(myObj);
					}
				}else if (event.keyCode == 221) {
					if (segments >= 2) {
					scene.removeChild(myObj);
					segments -= 1;
					myObj = new Plane(compoMat, 300, 300, segments, segments);
					scene.addChild(myObj);
					}
				}else if (event.keyCode == 37) {
				//left
					scene.removeChild(myObj);
					scene.removeChild(myObj2);
					myObj2 = new Sphere(compoMat,300,segments,segments);
					scene.addChild(myObj2);
				}else if (event.keyCode == 39) {
				//right
					scene.removeChild(myObj);
					scene.removeChild(myObj2);
					myObj = new Plane(compoMat, 300, 300, segments, segments);
					scene.addChild(myObj);
				}
				event.updateAfterEvent(); 
			}

			
			//camera.z 
			private function mouseWheelHandler (event:MouseEvent):void {
				if (event.delta > 0 ) {
					//camera.z += 20;
					camera.zoom += 0.1;
				}else{
					//camera.z -= 20;
					camera.zoom -= 0.1;
				}
			event.updateAfterEvent();  
			}
			
			
			
			
			private function timer_handler(e:Event):void 
			{
				var num:Number = 3;
				val = Math.floor(Math.random() * 30 + 1);
				for each(var i:Vertex3D in myObj.geometry.vertices) {
					
					var rnd:int = Math.random() * 250;
					var timeline:TweensyTimeline = Tweensy.to(i, {x:i.x * 1, y:i.y * 1, z:i.z - rnd}, 0.22,Elastic.easeOut );
						timeline.repeatType = TweensyTimeline.YOYO; 
						timeline.repeats = 1;
					

				num++;
				}
				renderer.renderScene(scene,camera,viewport);
			}
			
			private function onEnterFrame(event:Event):void
			{
				camera.x = (stage.mouseX - stage.stageWidth/2) *2;
				camera.y = (stage.mouseY - stage.stageHeight/2) *2;
				camera.target = myObj;
				//myObj.rotationZ += 0.4;
				  
				renderer.renderScene(scene, camera, viewport);
				
			}
        }
	}
		import flash.display.Sprite;
		class MousePointer extends Sprite {
			public function MousePointer() {
			graphics.lineStyle(1, 0x08FF10);
			graphics.moveTo(0,2);
			graphics.lineTo(5,2);
			graphics.moveTo(2,0);
			graphics.lineTo(2,5);
			}
		}
	