/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6qGXr
 */

/*
正方形の四隅をドラッグすると
大きくなったり小さくなったり。
*/




package {
    import flash.display.Sprite;
    
    import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
        
        
        
        public function FlashTest() {
            // write as3 code here..
            this.x = this.y = 200;
            init();
        }
        
        
        
        private var aim:Sprite = new Sprite();
        private var thumbContainer:Sprite = new Sprite();
        private var thumb0:Sprite = new Sprite();
        private var thumb1:Sprite = new Sprite();
        private var thumb2:Sprite = new Sprite();
        private var thumb3:Sprite = new Sprite();
        private var thumbAry:Array = [thumb0, thumb1, thumb2, thumb3];
        private var draggingThumb:Sprite;

        private var baseLength:Number = 100;
        private var dragLength:Number = 100;

private function init():void
{
	addChild(aim);
	addChild(thumbContainer);
	thumbContainer.addChild(thumb0);
	thumbContainer.addChild(thumb1);
	thumbContainer.addChild(thumb2);
	thumbContainer.addChild(thumb3);

	//aimの描画
	aim.graphics.beginFill(0, 0);
	aim.graphics.drawRect(-baseLength, -baseLength, baseLength * 2, baseLength * 2);
	aim.graphics.endFill();
	aim.graphics.beginFill(0x000000, 0.3);
	aim.graphics.moveTo(0, -baseLength);
	aim.graphics.lineTo(baseLength, -baseLength);
	aim.graphics.lineTo(baseLength, baseLength);
	aim.graphics.lineTo(-baseLength, baseLength);
	aim.graphics.lineTo(-baseLength, -baseLength);
	aim.graphics.lineTo(0, -baseLength);
	aim.graphics.lineTo(baseLength, 0);
	aim.graphics.lineTo(0, baseLength);
	aim.graphics.lineTo(-baseLength, 0);
	aim.graphics.lineTo(0, -baseLength);
	aim.graphics.endFill();

	//thumbの描画
	for (var i:int = 0; i < 4; i++)
	{
		var target:Sprite = thumbAry[i];
		target.graphics.beginFill(0xffffff, 0.3);
		target.graphics.lineStyle(0, 0);
		target.graphics.drawRect(0, 0, 20, 20);
		target.graphics.endFill();
		target.rotation = 90 * i;
	}
	thumb0.x = thumb3.x = -baseLength;
	thumb1.x = thumb2.x = baseLength;
	thumb0.y = thumb1.y = -baseLength;
	thumb2.y = thumb3.y = baseLength;

	//イベント
	aim.addEventListener(MouseEvent.MOUSE_DOWN, onAimDown);
	thumbContainer.addEventListener(MouseEvent.MOUSE_DOWN, onThumbDown);
}

private function onAimDown(evt:MouseEvent):void
{
	this.startDrag();
	this.addEventListener(MouseEvent.MOUSE_UP, onAimUp);
}
private function onAimUp(evt:MouseEvent):void
{
	this.stopDrag();
	this.removeEventListener(MouseEvent.MOUSE_UP, onAimUp);
}

private function onThumbDown(evt:MouseEvent):void
{
	this.draggingThumb = evt.target as Sprite;
	this.draggingThumb.startDrag();
	this.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
	this.addEventListener(MouseEvent.MOUSE_UP, onThumbUp);
}
private function onMouseMove(evt:MouseEvent):void
{
	this.dragLength = Math.max(Math.abs(this.draggingThumb.x), Math.abs(this.draggingThumb.y));	
	this.aim.scaleX = this.aim.scaleY = dragLength/baseLength;
}
private function onThumbUp(evt:MouseEvent):void
{
	this.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
	this.removeEventListener(MouseEvent.MOUSE_UP, onThumbUp);
	this.draggingThumb.stopDrag();
	thumb0.x = thumb3.x = -dragLength;
	thumb1.x = thumb2.x = dragLength;
	thumb0.y = thumb1.y = -dragLength;
	thumb2.y = thumb3.y = dragLength;
}

    }
}