/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6qG5
 */

// forked from sakusan393's アメーバっぽいもの
/*
10/04/05:self fork
TweenerをBetweenAS3にしてみた
よりアメーバっぽく
（赤丸がはみ出るときもあるけど）
*/
package  {
	//import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import net.hires.debug.Stats;
	
	[SWF(frameRate = 30, width = 500, height = 500 , backgroundColor = 0x000000)]
	
	/**
	 * ...
	 * @author 393
	 */
	public class RMain extends Sprite{
		
		private var _circles:Array = [];
		
		public function RMain() {
			addEventListener(Event.ADDED_TO_STAGE , init);
		}
		private function init(e:Event):void {
			
			addChild(new Stats());
			
			removeEventListener(Event.ADDED_TO_STAGE, init);

			var i:int;
			var circle:Sprite;
			for (i = 0; i < 6; i++) {
				addChild(circle =  new Circle());
				circle.x = Math.random() * stage.stageWidth;
				circle.y = Math.random() * stage.stageHeight;
			}
		}
	}
}
//import caurina.transitions.properties.ColorShortcuts;
//import caurina.transitions.properties.CurveModifiers;
//import caurina.transitions.properties.DisplayShortcuts;
//import caurina.transitions.Tweener;
import flash.display.BlendMode;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.geom.Point;
import flash.utils.Timer;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Back;
import org.libspark.betweenas3.easing.Expo;
import org.libspark.betweenas3.easing.Sine;
import org.libspark.betweenas3.tweens.ITween;

class Circle extends Sprite{
	
	private var _points:Array = [];
	private var _colors:Array = [];
	private var _copyPoints:Array = [];
	private var _container:Sprite;
	private var _radius:Number = Math.random() * 60 + 80;
	private var _pointRadius:Number = 5;
	private var _count:Number = 0;
	private var _maxCount:int = Math.random() * 3 + 2;
	private var _moveCount:int = 0;
	private var _unitRote:int = 1;
	private var _coreContainer:Sprite;
	
	public function Circle() {
		//ColorShortcuts.init();
		//DisplayShortcuts.init();
		//CurveModifiers.init();
		addEventListener(Event.ADDED_TO_STAGE , init);
	}
	
	private function init(e:Event):void {
		removeEventListener(Event.ADDED_TO_STAGE, init);
		
		_container = new Sprite();
		_coreContainer = new Sprite();
		_coreContainer.filters = [new BlurFilter(10,10)];
		addChild(_container);
		addChild(_coreContainer);
		this.alpha = Math.random() + 0.5;
		this.scaleX = 0;
		this.scaleY = 0;
		
		setPoint();
		trace(_points.length);
		drawFig();
		
		addEventListener(Event.ENTER_FRAME , enterFrameHandler);
		
		var timer:Timer = new Timer(Math.random() *600 + 600);
		timer.addEventListener(TimerEvent.TIMER, timerHandler);
		timer.start();
		
		var startTimer:Timer = new Timer(Math.random() * 1000,1);
		startTimer.addEventListener(TimerEvent.TIMER, startTimerHandler);
		startTimer.start();
		
		this.blendMode = BlendMode.ADD;
		_container.filters = [new BlurFilter(50, 50), new GlowFilter(0xFFFFFF)];
		
		this.addEventListener(MouseEvent.ROLL_OVER , overHandler);
	}
	private function startTimerHandler(e:TimerEvent):void {
		BetweenAS3.to(this, { scaleX:1, scaleY:1, alpha:Math.random() + 0.3 }, 2, Expo.easeInOut).play();
		//Tweener.addTween(this , { _scale:1,alpha:Math.random()+0.3, time:2, transition:"easeInOutExpo" } );
	}
	private function overHandler(e:MouseEvent):void {
		//Tweener.addTween(this , { _scale:1,alpha:0.3,time:1, transition:"easeOutExpo" ,onComplete:endScaleTween} );
		var iTween:ITween = BetweenAS3.to(this, { scaleX:0.2, scaleY:0.2, alpha:0.3 }, 1, Expo.easeOut);
		iTween.play();
		iTween.onComplete = endScaleTween;
		move();
	}
	private function endScaleTween():void{
		BetweenAS3.to(this, { scaleX:1, scaleY:1, alpha:Math.random() + 0.3 }, 2, Expo.easeInOut).play();
		//Tweener.addTween(this , { _scale:1,alpha:Math.random()+0.3, time:2, transition:"easeInOutExpo" } );
	}
	private function nextPos(isHorizon:Boolean = true ):Number {
		var maxLength:Number = stage.stageWidth;
		var currentLength:Number = this.x;
		if (isHorizon) {
			maxLength = stage.stageWidth;
			currentLength = this.x;
		}
		
		var pos:Number; 
		pos = Math.random() * 200 - 100;
		
		if ((pos + currentLength) > maxLength) {
			pos = currentLength - pos;
		}else if((pos + currentLength) < 0) {
			pos = currentLength - pos;
		}else {
			pos = currentLength + pos;
		}			
		return pos;
	}
	public function randomPlusMinus():int {
		var unit:int = 1;
		if (Math.random() > 0.5) unit *= -1;
		return unit;
	}
	public function move():void {
		var nextPosX:Number = nextPos(true);
		var nextPosY:Number = nextPos(false);
		
		var unitX:int = randomPlusMinus();
		var unitY:int = randomPlusMinus();
		BetweenAS3.bezierTo(this, { x:nextPosX, y:nextPosY},{x:nextPosX+30*unitX,y:nextPosY + 30*unitY}, 2, Back.easeInOut).play();
		BetweenAS3.to(this, {alpha:Math.random() + 0.3 }, 2, Expo.easeInOut).play();
		//Tweener.addTween(this, {  x:nextPosX , y:nextPosY,_bezier:{x:nextPosX+30*unitX,y:nextPosY + 30*unitY}, time:2, transition:"easeInOutBack" } );
	}
	private function timerHandler(e:TimerEvent):void {
		var i:int;
		_count += (Math.random() * 3 | 0);
		if (_count > 3) {
			_count = 0;
			for (i = 0; i < _points.length; i++) {
				BetweenAS3.to(_points[i], {x:_copyPoints[i].x, y:_copyPoints[i].y}, 1, Sine.easeInOut).play();
				//Tweener.addTween(_points[i], { x:_copyPoints[i].x, y:_copyPoints[i].y, time:1, transition:"easeInOutSine" } );
			}
			move();
		}else {
			setMovePoint();
		}
		if (Math.random() > 0.5) _unitRote *= -1;
	}
	private function setMovePoint():void{
		var i:int;
		for (i = 0; i < _points.length; i++) {
			BetweenAS3.to(_points[i], {x:_points[i].x +Math.random() * 100 - 50, y:_points[i].y+Math.random() *100 - 50}, 2, Back.easeOut).play();
			//Tweener.addTween(_points[i], { x:_points[i].x +Math.random() * 100 - 50, y:_points[i].y+Math.random() *100 - 50, time:2, transition:"easeOutBack" } );
		}
	}
	private function enterFrameHandler(e:Event):void {		
		drawFig();
		this.rotation += Math.random() *2* _unitRote;
	}
	private function drawFig():void{
		_container.graphics.clear();
		_coreContainer.graphics.clear();
		drawLine();
		drawPoint();
	}
	
	private function drawPoint():void{
		var g:Graphics = _coreContainer.graphics;
		var i:int;
		var radius:Number = 15;
		for (i = 0; i < 3; i++) {
			g.beginFill(0xFF3333);
			g.drawCircle(radius * Math.cos(i*120*Math.PI/180), radius * Math.sin(i*120*Math.PI/180), 5);
			g.endFill();
		}
	}
	private function drawLine():void {
		var g:Graphics = _container.graphics;
		g.beginFill(_colors[i]);
		var loop_cx:Number = ( _points[0].x + _points[_points.length - 1].x ) / 2;  
		var loop_cy:Number = ( _points[0].y + _points[_points.length - 1].y ) / 2;  
		g.moveTo(loop_cx,loop_cy);
		var i:int;
		for (i = 0; i < _points.length-1; i++) {
			g.curveTo(_points[i].x, _points[i].y, (_points[i].x+_points[i + 1].x)/2, (_points[i].y + _points[i + 1].y)/2);
		}
		g.curveTo(_points[i].x, _points[i].y, loop_cx, loop_cy);
	}
	private function setPoint():void {
		var i:int;
		for (i = 0; i < 8; i++) {
			var dx:Number = _radius * Math.cos(i * Math.PI / 4);
			trace("dx : " + dx);
			var dy:Number = _radius * Math.sin(i * Math.PI / 4);
			_points.push(new Point(dx, dy));
			_copyPoints.push(new Point(dx, dy));
			var col:Number = 0xFF * Math.random();
			var color:Number = 0 << 16 | 0x99*Math.random() << 8 | 0
			_colors.push(color);
		}	
	}
}
