/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6qD5
 */

// forked from Aquioux's graphics.drawPath の練習(1)
package {
	import flash.display.Sprite;
	import flash.display.GraphicsPathCommand;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#FFFFFF")]
	/**
	 * graphics.drawPath の練習(2)
	 * @author Yoshida, Akio
	 */
	public class Main extends Sprite {
		private var anchorContainer:Sprite;		// アンカー用キャンバス
		private var lineContainer:Sprite;		// ライン用キャンバス
		private var commandVector:Vector.<int>;		// 線種格納　Vector
		private var anchorVector:Vector.<Number>;	// アンカー座標格納 Vector
		private var currentAnchor:Anchor;		// 現在ドラッグ中のアンカー
		
		public function Main() {
			init();			// 初期化
			lineDraw();		// ラインの描画
		}
		
		// 初期化
		private function init():void {
			// 説明文
			var textField:TextField = new TextField();
			textField.text = "円をドラッグしてください";
			textField.selectable = false;
        		textField.width = stage.stageWidth;
			addChild(textField);
			
			// ライン用キャンバスの生成
			lineContainer = new Sprite();
			addChild(lineContainer);
			
			// アンカー用キャンバスの生成
			anchorContainer = new Sprite();
			addChild(anchorContainer);
			
			// アンカー座標の計算
			var length:uint = 100;
			var marginX:Number = (465 - length) / 2;
			var marginY:Number = (465 - length * 4) / 2;
			anchorVector  = new Vector.<Number>();
			anchorVector.push(marginX, marginY);
			anchorVector.push(marginX + length, marginY);
			anchorVector.push(marginX + length, marginY + length);
			anchorVector.push(marginX, marginY + length);
			anchorVector.push(marginX, marginY + length * 2);
			anchorVector.push(marginX + length, marginY + length * 2);
			anchorVector.push(marginX + length, marginY + length * 3);
			anchorVector.push(marginX, marginY + length * 3);
			anchorVector.push(marginX, marginY + length * 4);
			//anchorVector.push(marginX + length, marginY + length * 4);
			
			// アンカーの生成
			var numOfAnchor:uint = anchorVector.length / 2;
			for (var i:uint = 0; i < numOfAnchor; i++) {
				var color:uint = (i % 2) ? 0x0000FF : 0xFF0000;
				var anchor:Anchor = new Anchor(i, color);
				anchor.x = anchorVector[i * 2];
				anchor.y = anchorVector[i * 2 + 1];
				anchor.addEventListener(MouseEvent.MOUSE_DOWN, anchor_MouseDownHandler);
				anchor.addEventListener(MouseEvent.MOUSE_UP,   anchor_MouseUpHandler);
				anchorContainer.addChild(anchor);
			}
			
			// 線種
			commandVector = new Vector.<int>();
			commandVector[0] = GraphicsPathCommand.MOVE_TO;
			for (i = 1; i < numOfAnchor; i++) {
				commandVector[i] = GraphicsPathCommand.CURVE_TO;
			}
		}
		
		// アンカー対象のマウスイベントハンドラ（マウスダウン）
		private function anchor_MouseDownHandler(event:MouseEvent):void {
			currentAnchor = Anchor(event.target);
			currentAnchor.startDrag();
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		// アンカー対象のマウスイベントハンドラ（マウスアップ）
		private function anchor_MouseUpHandler(event:MouseEvent):void {
			currentAnchor.stopDrag();
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		
		// ステージ対象のマウスイベントハンドラ（マウスムーブ）
		private function mouseMoveHandler(e:MouseEvent):void {
			var idx:uint = currentAnchor.idx;
			anchorVector[idx * 2]     = currentAnchor.x;
			anchorVector[idx * 2 + 1] = currentAnchor.y;
			lineDraw();		// ラインの描画
		}
		
		// ラインの描画
		private function lineDraw():void {
			lineContainer.graphics.clear();
			lineContainer.graphics.lineStyle(0, 0x000000);
			lineContainer.graphics.drawPath(commandVector, anchorVector);
			lineContainer.graphics.endFill();
		}
	}
}


import flash.display.Sprite;

class Anchor extends Sprite {
	private var _idx:uint;
		
	public function Anchor(idx:uint, color:uint = 0xFF0000) {
		_idx = idx;
		graphics.beginFill(color, 0.5);
		graphics.drawCircle(0, 0, 10);
		graphics.endFill();
		buttonMode = true;
	}
	
	public function get idx():uint { return _idx; }
}
