/**
 * Copyright __dominic ( http://wonderfl.net/user/__dominic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6pg9
 */

package 
{
    
    import flash.display.*;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite 
    {
        
        private const NORM:int = 100;
        
        private var _container:Sprite;
        private var _bitmap:Bitmap;
        private var _bmpData:BitmapData;
        private var _p:Array;
        private var _nParticles:int;
        private var _bf:BlurFilter;
        private var _timer:Timer;
        private var _g:Number = .2;
        private var _color:uint;
        private var _ca:Number = 0;
        
        public function FlashTest() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            _container = new Sprite();
            
            _bmpData = new BitmapData( stage.stageWidth,
                                       stage.stageHeight,
                                       false, 0 );
            _bitmap = new Bitmap( _bmpData );
            addChild( _bitmap );
            
            _color = 0xFFFFFF;
            
            _bf = new BlurFilter( 4, 4, 1 );
            stage.addEventListener( MouseEvent.CLICK, init );
            init( null );
        }
        
        private function init( e:MouseEvent ):void
        {
            if ( _timer )
            {
                _timer.stop();
                _timer.removeEventListener( TimerEvent.TIMER, tickHandler );
            }
            _p = [];
            _nParticles = 512;
            for ( var i:int = 0; i < _nParticles; i++ )
            {
                var px:Number = stage.stageWidth >> 1;
                var py:Number = 25;
                _p[ i ] = { x:px, y:py, vx:0, vy:0 };
            }
            
            _timer = new Timer( 25 );
            _timer.addEventListener( TimerEvent.TIMER, tickHandler, false, 0, true );
            _timer.start();
        }
        
        private function tickHandler( e:TimerEvent ):void
        {
            _container.graphics.clear();
            _container.graphics.beginFill( _color );
            for ( var i:int = 0; i < _nParticles; i++ )
            {                
                var obj:Object = _p[ i ];
                obj.vx += Math.random() * .6 - .3;
                obj.vy += Math.random() * .4 - .2;
                if ( i > 2 )
                {
                    var dx:int = mouseX - obj.x;
                    var dy:int = mouseY - obj.y;
                    var dist:int = Math.sqrt( dx * dx + dy * dy );
                    if ( dist < NORM )
                    {
                        var tx:int = mouseX - NORM * dx / dist;
                        var ty:int = mouseY - NORM * dy / dist;
                        obj.vx += ( tx - obj.x ) * .2;
                        obj.vy += ( ty - obj.y ) * .2;
                    }
                    obj.vy += _g;
                }
                obj.vx *= .999;
                obj.vy *= .999;
                obj.x += obj.vx;
                obj.y += obj.vy;
                
                if ( obj.x <= 0 ) 
                {
                    obj.x = 1;
                    obj.vx *= -1;
                }
                else if ( obj.x >= stage.stageWidth )
                {
                    obj.x = stage.stageWidth - 1;
                    obj.vx *= -1;
                }
                
                if ( obj.y <= 0 )
                {
                    obj.y = 1;
                    obj.vy *= -1;
                }
                else if ( obj.y >= stage.stageHeight )
                {
                    obj.y = stage.stageHeight - 1;
                    obj.vy *= -1;
                }
                
                _p[ i ] = obj;
                _container.graphics.drawCircle( _p[ i ].x, _p[ i ].y, 1 );
            }
            _bmpData.draw( _container );
            _bmpData.applyFilter( _bmpData,
                                  _bmpData.rect,
                                  new Point(), _bf );
            updateColor();
        }
        
        private function updateColor():void
        {
            var r:uint = ( _p[ 0 ].y / stage.stageHeight ) * 255;
            var g:uint = ( _p[ 1 ].y / stage.stageHeight ) * 255;
            var b:uint = ( _p[ 2 ].y / stage.stageHeight ) * 255;
            _color = r << 16 | g << 8 | b;
        }
        
    }
        
}
