/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6pTW
 */

package {
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;

    public class FlashTest extends Sprite {
        public var offset:Number;
        public var angles:Array;
        public var centerX:Number = 465 / 2;
        public var centerY:Number = 465 / 2;
        public var numShapes:int = 3;
        public var scaleFactor:Number = .6;
        public var size:Number = 465 / 5;
        public var dist:Number = size * 1.5;
        
        public var mainDepth:int = 8;
        
        public var _bitmap:Bitmap;
        public var _bitmapData:BitmapData;
        
        public var mat:Matrix;
        public var circles:Array;
        public var rects:Array;
        public var _circleRadioButton:RadioButton;
        public var _rectRadioButton:RadioButton;
      
        public function FlashTest() {
            
            // write as3 code here..
            _bitmapData = new BitmapData(465, 465, true, 0xff292929);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            circles = [];
            var circle:Shape;
            var circleRadius:Number = size;
            var i:int;
            for (i = 0; i < mainDepth + 1; i += 1) //initialize Circles
            {
                circle = new Shape();
                circle.graphics.beginFill(0xffffff, 0.1);
                circle.graphics.drawCircle(0, 0, circleRadius);
                circle.graphics.endFill();
                
                circles.push(circle);
                
                circleRadius *= scaleFactor;
            }
            
            rects = [];
            var rect:Shape;
            var rectRadius:Number = size;
            for (i = 0; i < mainDepth + 1; i += 1) //initialize Circles
            {
                rect = new Shape();
                rect.graphics.beginFill(0xffffff, 0.1);
                rect.graphics.drawRect( -rectRadius / 2, -rectRadius / 2, rectRadius, rectRadius);
                rect.graphics.endFill();
                
                rects.push(rect);
                
                rectRadius *= scaleFactor;
            }
            
            var _symButton:PushButton = new PushButton(this, 10, 465 - 30, "Symmetric", onReset);
            var _asymButton:PushButton = new PushButton(this, _symButton.x + _symButton.width + 10, 465 - 30, "Asymmetric", onResetAsym);
            
            _circleRadioButton = new RadioButton(this, 10, _symButton.y - 20, "circle Shape");
            _circleRadioButton.selected = true;
            _circleRadioButton.groupName = "ShapeSelect";
            _rectRadioButton = new RadioButton(this, _circleRadioButton.x + _circleRadioButton.width + 10, _circleRadioButton.y, "rect Shape");
            _rectRadioButton.groupName = "ShapeSelect";

            onReset();
        }
        
        private function onResetAsym(e:Event):void
        {
            _bitmapData.fillRect(_bitmapData.rect, 0xff292929);
            
            //offset = Math.random() * Math.PI * 2;
            angles = [Math.random() * Math.PI * 2, Math.random() * Math.PI * 2, Math.random() * Math.PI * 2];
            
            mat = new Matrix();
            mat.translate(centerX, centerY);
            
            if (_circleRadioButton.selected == true)
            {
                _bitmapData.draw(circles[0], mat);
            }
            else
            {
                _bitmapData.draw(rects[0], mat);
            }
            
            iterateAsym(centerX, centerY, mainDepth - 1, size * scaleFactor, dist * scaleFactor, angles[0]);
            iterateAsym(centerX, centerY, mainDepth - 1, size * scaleFactor, dist * scaleFactor, angles[1]);
            iterateAsym(centerX, centerY, mainDepth - 1, size * scaleFactor, dist * scaleFactor, angles[2]);
        }

        
        private function onReset(e:Event = null):void
        {
            _bitmapData.fillRect(_bitmapData.rect, 0xff292929);
            
            offset = Math.random() * Math.PI * 2;
            angles = [offset, offset + Math.PI * 2 / 3, offset + Math.PI * 4 / 3];
            
            mat = new Matrix();
            mat.translate(centerX, centerY);
            
            if (_circleRadioButton.selected == true)
            {
                _bitmapData.draw(circles[0], mat);
            }
            else
            {
                _bitmapData.draw(rects[0], mat);
            }
            
            iterate(centerX, centerY, mainDepth - 1, size * scaleFactor, dist * scaleFactor, angles[0]);
            iterate(centerX, centerY, mainDepth - 1, size * scaleFactor, dist * scaleFactor, angles[1]);
            iterate(centerX, centerY, mainDepth - 1, size * scaleFactor, dist * scaleFactor, angles[2]);
        }
        
        private function iterate(x:Number, y:Number, depth:int, size:Number, dist:Number, angle:Number):void
        {
            var i:int;
            var tx:Number;
            var ty:Number;
            
            for (i = 0; i < numShapes; i += 1)
            {
                tx = x + Math.cos(angle) * dist;
                ty = y + Math.sin(angle) * dist;
                
                mat = new Matrix();
                mat.translate(tx, ty);
                if (_circleRadioButton.selected == true)
                {
                    _bitmapData.draw(circles[mainDepth - depth], mat);
                }
                else
                {
                    _bitmapData.draw(rects[mainDepth - depth], mat);
                }
                
                if (depth > 0)
                {
                    iterate(tx, ty, depth - 1, size * scaleFactor, dist * scaleFactor, angle + angles[i]);
                }
            }
        }
        
        private function iterateAsym(x:Number, y:Number, depth:int, size:Number, dist:Number, angle:Number):void
        {
            var i:int;
            var tx:Number;
            var ty:Number;
            
            for (i = 0; i < numShapes; i += 1)
            {
                var angleOffset:Number = Math.random() - .5;
                var distMultOffset:Number = Math.random() * .5 + 1;
                tx = x + Math.cos(angle + angleOffset) * dist * distMultOffset;
                ty = y + Math.sin(angle + angleOffset) * dist * distMultOffset;
                
                mat = new Matrix();
                mat.translate(tx, ty);
                if (_circleRadioButton.selected == true)
                {
                    _bitmapData.draw(circles[mainDepth - depth], mat);
                }
                else
                {
                    _bitmapData.draw(rects[mainDepth - depth], mat);
                }

               
                if (depth > 0)
                {
                    iterateAsym(tx, ty, depth - 1, size * scaleFactor, dist * scaleFactor, angle + angles[i]);
                }
            }
        }
    }
}