/**
 * Copyright hacker_zxh9vkwz ( http://wonderfl.net/user/hacker_zxh9vkwz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ogU
 */

// forked from Saqoosha's Something like Nerhol
package {

    import com.adobe.images.PNGEncoder;
    import com.bit101.components.HBox;
    import com.bit101.components.PushButton;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.TimerEvent;
    import flash.filters.BevelFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.net.FileReference;
    import flash.utils.Timer;


    /**
     * Webcam required.
     * @author Saqoosha
     * @see http://nerhol.com/
     */
    [SWF(backgroundColor="#FFFFFF", frameRate="30", width="465", height="465")]
    public class SomethingLikeNerhol extends Sprite {
        
        
        private static const PT:Point = new Point();
        private static const RECT:Rectangle = new Rectangle(0, 0, 465, 465);


        private var _noise:BitmapData = new BitmapData(465, 465, false, 0x0);
        private var _final:BitmapData = new BitmapData(465, 465, false, 0x0);
        private var _video:Video = new Video(640, 480);

        private var _tmp:BitmapData = new BitmapData(465, 465, true, 0x0);
        private var _color:BitmapData = new BitmapData(465, 465, true, 0x0);
        private var _mtx:Matrix = new Matrix(-1, 0, 0, 1, 552.5, 0);
        private var _bevel:BevelFilter = new BevelFilter(1, 45, 0xffffff, 0.2, 0x0, 0.2, 1, 1, 1, BitmapFilterQuality.LOW);
        
        private var _min:int = 0;
        private var _max:int = 0;
        private var _current:int = 1;
        
        private var _timer:Timer = new Timer(50);
        
        
        public function SomethingLikeNerhol() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var cam:Camera = Camera.getCamera();
            if (!cam) return;
            cam.setMode(640, 480, 30);
            _video.attachCamera(cam);
            _video.smoothing = true;
            
            addChild(new Bitmap(_final));
            
            var hbox:HBox = new HBox(this, 5, 5);
            new PushButton(hbox, 0, 0, 'GENERATE', _generate).width = 80;
            new PushButton(hbox, 0, 0, 'SAVE', _save).width = 50;
            
            _timer.addEventListener(TimerEvent.TIMER, _update);
        }


        private function _generate(e:* = null):void {
            var o:Number = Math.random() * 300 + 200;
            _noise.perlinNoise(o, o, 2, new Date().getTime(), false, true, 7, true);

            var hist:Vector.<Number> = _noise.histogram()[0];
            for (_min = 0; _min < 256; _min++) {
                if (hist[_min]) break;
            }
            for (_max = 255; _max >= 0; _max--) {
                if (hist[_max]) break;
            }
            _current = _min;
            _timer.start();
        }
        
        
        private function _update(e:* = null):void {
            _tmp.fillRect(RECT, 0x0);
            _tmp.threshold(_noise, RECT, PT, '>=', _current, 0xffffffff, 0xff);
            _color.draw(_video, _mtx, null, null, null, true);
            _color.copyChannel(_tmp, RECT, PT, BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
            _color.applyFilter(_color, RECT, PT, _bevel);
            _final.copyPixels(_color, RECT, PT);
            if (++_current > _max) _timer.stop();
        }
        
        
        private function _save(e:* = null):void {
            new FileReference().save(PNGEncoder.encode(_final), 'something-like-nerhol.png');
        }
    }
}
