/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6oTv
 */

// forked from hacker_ld55f_c1's forked from: forked from: nengafl
// forked from uwi's forked from: nengafl
// forked from nengafl's nengafl
package {
    import flash.text.TextField;
    import flash.events.Event;
    
    import org.papervision3d.core.proto.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    
    import jiglib.math.*;
    import jiglib.geometry.*;
    import jiglib.physics.*;
    import jiglib.physics.constraint.*;
    import jiglib.plugin.papervision3d.*;
    
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor="0x000000", frameRate="60")]
    public class PV3D extends BasicView {
        private var _light : LightObject3D;
        
        private var _tf : TextField;
        
        public function PV3D() {
            super(0, 0, true, false);
            
            init();
            
            _tf = new TextField();
            addChild(_tf);
            _tf.textColor = 0xffffff;
            _tf.width = 100;
            _tf.height = 465;
            
            //addChild(new Stats());

            startRendering();
        }
        
        private function init() : void
        {
            PhysicsSystem.getInstance().setGravity(new JNumber3D(0, -10, 0));
            PhysicsSystem.getInstance().setSolverType("FAST");
            
            _light = new PointLight3D(true, true);
            _light.x = 0; _light.y = 400; _light.z = 0;
            
            camera.x = -300; camera.y = 300, camera.z = -300;
            
            
            _pv3dp = new Papervision3DPhysics(scene, 3);
            
//            var ground : RigidBody = _pv3dp.createGround(new ColorMaterial(0x999999), 2000, 10);
            var ground : RigidBody = _pv3dp.createGround(new FlatShadeMaterial(_light, 0x999999), 2000, 1);
            ground.friction = 1.0;
            ground.restitution = 0.5;
            
            _dominos = new Vector.<RigidBody>();
            
            var ml : MaterialsList = new MaterialsList();
            
            for(var i : uint = 0;i < 7;i++){
                for(var j : uint = 0;j < i + 1;j++){
                    var spectrum = Math.round( Math.random()*0xFFFFFF );
                    ml.addMaterial(new FlatShadeMaterial(_light, spectrum), "all");
                    var domino : RigidBody = _pv3dp.createCube(ml, 20, 50, 100);
                    domino.mass = 10;
                    domino.y = 50;
                    domino.x = i * 70;
                    domino.z = -25 * i + 50 * j;
                    _dominos.push(domino);
                }
            }
            _dominos[0].addBodyForce(new JNumber3D(2000, -2000, 0), new JNumber3D(0, 0, 0));
        }
        
        private var _pv3dp : Papervision3DPhysics;
        
        private var _dominos : Vector.<RigidBody>;
        
        override protected function onRenderTick(e : Event = null) : void
        {
//            PhysicsSystem.getInstance().integrate(0.2);
            _pv3dp.step();
            super.onRenderTick(e);
        }
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}
