/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6oRO
 */

/*
 * perlinNoiseの色を位置情報に置き換えてみたらどうなるか試してみた
 * …だけ
 */
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        private var offsets:Array = [new Point(), new Point()];
        private var rect:Rectangle = new Rectangle(0,0,460,460);
        private var blurFilter:BlurFilter = new BlurFilter(32,32,1);
        public function FlashTest() {
            var noise:BitmapData = new BitmapData(128,128);
            var canvas:BitmapData = new BitmapData(460,460,false,0xff000000);
            var bm:Bitmap = new Bitmap(canvas);
            addChild(bm);
            addEventListener(Event.ENTER_FRAME, function (e:Event):void {
                canvas.applyFilter(canvas,rect,new Point(0,-8),blurFilter);
                offsets[0].offset(1,1);
                offsets[1].offset(-1,-1);
                noise.perlinNoise(64,64,2,1,true,true,7,false,offsets);
                for (var i:int = 0; i < 16384; i++) {
                    var rgb:int = noise.getPixel(i/128,i%128);
                    //var nR:int = (rgb >> 16) & 0xff;
                    var nG:int = (rgb >> 8) & 0xff;
                    var nB:int = rgb & 0xff;
                    canvas.setPixel(nG+98,nB+218,rgb);
                }
            });
        }
    }
}