/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6nin
 */

// forked from 3f5's flash on 2011-8-8
package {
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.text.TextFormat;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var textFormat:TextFormat = new TextFormat();
            textFormat.size = 100;
            var text:TextField = new TextField();
            text.text = 'あ';
            text.autoSize = 'left';
            text.setTextFormat(textFormat);
            //text.scaleX = (stage.stageWidth / text.width);
            //text.scaleY = (stage.stageHeight / text.height);
            
            var bitmap:BitmapData = new BitmapData(text.width, text.height, true);
            bitmap.draw(text);
            
            stage.addChild(text);
            
            var sprite:Sprite = new Sprite();
            
            var currentColor:uint = 0xFFFFFF, x:int = 0, y:int = 0, map:Object = {};
            
            for (var _x:int = 0; _x < text.width; _x++) {
                map[_x] = {};
                
                for (var _y:int = 0; _y < text.height; _y++) {
                    map[_x][_y] = true;
                }

            }
            
            stage.addChild(sprite);

            
            (function ():void {
                if (map[x+1] && map[x+1][y+1] && compColor(bitmap.getPixel(x, y+1), currentColor)) {
                    y+=1;
                }
                else if (map[x+1] && map[x+1][y] && compColor(bitmap.getPixel(x+1, y), currentColor)) {
                    x+=1;
                }
                else if (map[x] && map[x][y-1] && compColor(bitmap.getPixel(x, y-1), currentColor)) {
                    y-=1;
                }
                else if (map[x-1] && map[x-1][y] && compColor(bitmap.getPixel(x-1, y), currentColor)) {
                    x-=1;
                }
                else if (map[x-1] && map[x-1][y-1] && compColor(bitmap.getPixel(x-1, y-1), currentColor)) {
                    x-=1;
                    y-=1;
                }
                else if (map[x-1] && map[x-1][y+1] && compColor(bitmap.getPixel(x-1, y+1), currentColor)) {
                    x-=1;
                    y+=1;
                }
                else if (map[x+1] && map[x+1][y-1] && compColor(bitmap.getPixel(x+1, y-1), currentColor)) {
                    x+=1;
                    y-=1;
                }
                else if (map[x] && map[x][y+1] && compColor(bitmap.getPixel(x+1, y+1), currentColor)) {
                    x+=1;
                    y+=1;
                }
                else {
                    x = Math.floor(Math.random() * text.width);
                    y = Math.floor(Math.random() * text.height);
                    sleep(50, arguments.callee);
                    //sprite.graphics.drawRect(0, 0, 50, 50);
                    //return;
                }
                
                text.text = 'x' + String(x) + 'y' + String(y);

                map[x][y] = false;
                
                sprite.graphics.lineStyle(1, 0x000000);
                sprite.graphics.lineTo(x, y);
                
                sleep(50, arguments.callee);
            })();
            


        }
        
        public function sleep(delay:int, callback:Function):void {
            var timer:Timer = new Timer(delay, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, callback);
            timer.start();
        }
        
        public function compColor(col1:uint, col2:uint):Boolean {
            if (col1 === 0 || col2 === 0) return false;
            
            var r1:Number = (col1 >> 16) & 0xFF;
            var g1:Number = (col1 >>  8) & 0xFF;
            var b1:Number = (col1 >>  0) & 0xFF;
            
            var r2:Number = (col2 >> 16) & 0xFF;
            var g2:Number = (col2 >>  8) & 0xFF;
            var b2:Number = (col2 >>  0) & 0xFF;
            
            if (Math.abs(r1 - r2) <= 20 && Math.abs(r1 - r2) <= 20 && Math.abs(g1 - g2) <= 20 && Math.abs(b1 - b2) <= 20) {
                return true;
            }
            else {
                return false;
            }


        }


    }
}