/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ngy
 */

package {
    import flash.display.Sprite;
    import flash.system.Security;
    import org.libspark.thread.Thread;
    import org.libspark.thread.EnterFrameThreadExecutor;
    
    [SWF(backgroundColor="#333333", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var filePath:String = "http://www.project-nya.jp/images/flash/thread.data.xml";
        private var thread:MainThread;
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            graphics.beginFill(0x333333);
            graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            if(!Thread.isReady) Thread.initialize(new EnterFrameThreadExecutor());
            start();
        }
        private function start():void {
            Security.allowDomain("www.project-nya.jp");
            Security.loadPolicyFile("http://www.project-nya.jp/crossdomain.xml");
            
            thread = new MainThread(this, filePath);
            thread.start();
        }
    }
}

import flash.display.Sprite;
import flash.net.URLRequest;
import org.libspark.thread.Thread;
import org.libspark.thread.threads.net.URLLoaderThread;

class MainThread extends Thread {
    private var container:Sprite;
    private var filePath:String;
    private var loader:URLLoaderThread;
    private var photos:Array;
    private static var basePath:String = "http://www.project-nya.jp";
    
    public function MainThread(c:Sprite, f:String) {
        container = c;
        filePath = f;
    }
    
    override protected function run():void {
        loader = new URLLoaderThread(new URLRequest(filePath));
        loader.start();
        loader.join();
        next(parse);
    }
    private function parse():void {
        var xml:XML = new XML(loader.loader.data);
        photos = new Array();
        for(var n:uint=0; n < xml.photo.length(); n++) {
            var photo:XML = xml.photo[n];
            photos.push(basePath+String(photo));
        }
        next(load);
    }
    private function load():void {
        var loader:PhotoMultiLoaderThread = new PhotoMultiLoaderThread(container, photos);
        loader.start();
    }
    override protected function finalize():void {
        
    }
}

import flash.display.Sprite;
import org.libspark.thread.Thread;
import org.libspark.thread.utils.SerialExecutor;

class PhotoMultiLoaderThread extends Thread {
    private var container:Sprite;
    private var photos:Array;
    private var threads:SerialExecutor;
    
    public function PhotoMultiLoaderThread(c:Sprite, list:Array) {
        container = c;
        photos = list;
    }
    override protected function run():void {
        threads = new SerialExecutor();
        for(var n:uint = 0; n < photos.length; n++) {
            var filePath:String = photos[n];
            var loader:PhotoLoaderThread = new PhotoLoaderThread(n, container, filePath);
            threads.addThread(loader);
        }
        threads.start();
        threads.join();
    }
}

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.Bitmap;
import flash.net.URLRequest;
import org.libspark.thread.Thread;
import org.libspark.thread.threads.display.LoaderThread;

class PhotoLoaderThread extends Thread {
    private var tid:uint;
    private var container:Sprite;
    private var filePath:String;
    private var sw:uint;
    private var sh:uint;
    private var loader:LoaderThread;
    
    public function PhotoLoaderThread(n:uint, c:Sprite, f:String) {
        tid = n;
        container = c;
        filePath = f;
        sw = container.stage.stageWidth;
        sh = container.stage.stageHeight;
    }
    
    override protected function run():void {
        loader = new LoaderThread(new URLRequest(filePath));
        loader.start();
        loader.join();
        next(loaded);
    }
    private function loaded():void {
        var loader:Loader = loader.loader;
        var content:Bitmap = Bitmap(loader.content);
        container.addChild(content);
        content.x = 12 + 90 * (tid % 5) + (80 - content.width) / 2;
        content.y = 12 + 90 * uint(tid/5) + (80 - content.height) / 2;
    }
    override protected function finalize():void {
        
    }
}

