/**
 * Copyright takashi08 ( http://wonderfl.net/user/takashi08 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6nCg
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;

    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.*;

    [SWF(backgroundColor=0x000000)]
    public class Papervision3D_sample39 extends Sprite
    {
        private var container:Sprite;
        private var viewport:Viewport3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var render:BasicRenderEngine;
        private var rootNode:DisplayObject3D;
        private var Theta:Number=0;
        private var planeN:Number=20;
        private var radius:Number=250;
        private var planeSizeX:Number=30;
        private var planeSizeY:Number=40;
        private var datumPoint:Number=-70;

        public function Papervision3D_sample39()
        {
            stage.frameRate=40;
            stage.quality=StageQuality.HIGH;
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;

            container=new Sprite();
            addChild(container);
            container.x=stage.stageWidth / 2;
            container.y=stage.stageHeight / 2;
            stage.addEventListener(Event.RESIZE, onResize);

            viewport=new Viewport3D(0, 0, true, true);
            scene=new Scene3D();
            camera=new Camera3D();
            render=new BasicRenderEngine();
            rootNode=scene.addChild(new DisplayObject3D("rootNode"));
            addEventListener(Event.ENTER_FRAME, onFrame);

            addChild(viewport);
            camera.zoom=30;
            camera.z = -2000;
            camera.focus=140;
            camera.y=3000;
            camera.target=DisplayObject3D.ZERO;
            
            
            

            var light:PointLight3D=new PointLight3D();
            light.x=-45;
            light.z=-45;
            light.y=200;
            scene.addChild(light);

            var theta:Number=0;
            var mat:FlatShadeMaterial=new FlatShadeMaterial(light, 0x00ff33, 0x111111);
            mat.doubleSided=true;
            for (var i:int=0; i < planeN; i++)
            {
                var p:Plane=new Plane(mat, planeSizeX, planeSizeY);
                rootNode.addChild(p, "plane" + i.toString());
                p.z=radius * Math.cos(theta * Math.PI / 180);
                p.x=radius * Math.sin(theta * Math.PI / 180);
                p.rotationY=theta;
                theta+=360 / planeN;

                // これによって、filterやalpha値が設定できる
                p.useOwnContainer=true;
            }
            
            
            //カメラを移動
            var cameraTween:ITween = BetweenAS3.tween(camera,{z:-500,y:0},null,3);
            cameraTween.play();
            
            var rootTween:ITween = BetweenAS3.tween(rootNode,{rotationY:360},null,3);
            rootTween.play();
            
            
        }

        public function onResize(e:Event):void
        {
            container.x=stage.stageWidth / 2;
            container.y=stage.stageHeight / 2;
        }

        public function onFrame(e:Event):void
        {
            Theta+=0.5;
            var theta:Number=Theta;
            for (var i:int=0; i < planeN; i++)
            {
                var p:Plane=rootNode.getChildByName("plane" + i.toString()) as Plane;
                p.z=radius * Math.cos(theta * Math.PI / 180);
                p.x=radius * Math.sin(theta * Math.PI / 180);
                p.rotationY=theta;
                theta+=360 / planeN;

                // blurfilterを適用
                var b:Number=-(datumPoint - p.z) / 10;
                p.filters=[new BlurFilter(b, b, 1)];
            }
            render.renderScene(scene, camera, viewport);
        }
    }
} 