/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6lul
 */

// forked from yuuganisakase's Trefoil Knot
//三葉結び目
//http://mathworld.wolfram.com/TrefoilKnot.html

package
{
    import net.hires.debug.Stats;
    import com.bit101.components.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Vector3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.shadematerials.PhongMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.BasicView;
    
    [SWF(width="465", height="465", backgroundColor="0x222222", frameRate="20")]
    public class ThreeFoilKnot extends BasicView
    {
        private var txt:Text;
        private var coprimes:Array = [[3,2],[5,2],[4,1],[4,3],[8,5],[7,4],[8,3],[12,5],[9,4],[7,2],[9,2],[6,1],[5,4],[11,8],[10,7],[13,8],[19,12],[14,9],[12,7],[16,9]];
        private var cpidx:int = 1;

        private const BLUR:BlurFilter = new BlurFilter(4, 4, 2);    
        private var counter:Number = 0;
        
        private var a:Number = 1;
        private var b:Number = 0.3;
        private var c:Number = 0.5;
        private var d:Number = 0.5;

        private var p:int = 2;
        private var q:int = 3;
        
        private const Ustep:Number = 0.15;
        private const Vstep:Number = 0.4;
        private var light:PointLight3D;
        private var shade:FlatShadeMaterial;// PhongMaterial;
        private var holder:DisplayObject3D;
        private var plArray:Array = new Array();

        public function ThreeFoilKnot()
        {
            // txt = new Text(this);
            // txt.height = txt.width = 465;
            addChild(new Stats);
            stage.quality = "medium";
            Wonderfl.capture_delay(6.5);
            super(465 / 4, 465 / 4, true, true, "Target");
            light = new PointLight3D();
            shade = new FlatShadeMaterial(light, 0xffeeff, 0x554455, 1);////PhongMaterial(light, 0xffeeff, 0x554455, 1);
            //shade.doubleSided = true;
            
            holder = new DisplayObject3D();
            //viewport.filters = [BLUR];
            scene.addChild(holder);
            holder.z = -330;
            holder.y = -210;
            camera.target = holder
            startRendering();
            addEventListener(Event.ENTER_FRAME, onFrame);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onClick(e:MouseEvent):void 
        {
            counter = 0;
            for (var i:int = 0; i < plArray.length; i++) 
            {
                holder.removeChild(plArray[i]);
            }
            plArray.length = 0;
            a = 0.5 + Math.random() * 1;
            b = 0.2 + Math.random() * 0.4;
            c = 0.3 + Math.random() * 0.6;;
            d = 0.2 + Math.random() * 0.25;
            holder.rotationX = Math.random() * 180;
            var cp:Array = coprimes[cpidx++];
            if(cpidx == coprimes.length) cpidx = 0;
            q = cp[0];
            p = cp[1];
        }
        
        private function onFrame(e:Event):void
        {
            if(counter < Math.PI*4){
                counter += Ustep;
                for (var j:Number = 0; j < Math.PI * 2; j += Vstep) 
                {
                    plot(counter, j);
                }
            }
            holder.rotationY += 1.5;
        }
        private function plot(uu:Number, vv:Number):void
        {
            var v1:Number3D = calc(uu, vv);
            var v2:Number3D = calc(uu + Ustep, vv);
            var v3:Number3D = calc(uu , vv+Vstep);
            var v4:Number3D = calc(uu + Ustep, vv+Vstep);
            
            var pl:MyPlane = new MyPlane(shade, v1, v2, v3);
            var pl2:MyPlane = new MyPlane(shade, v2, v4, v3);
            
            plArray.push(pl);
            plArray.push(pl2);
            holder.addChild(pl);
            holder.addChild(pl2);
            pl.x = (v1.x + v2.x + v3.x) / 3;
            pl2.x = (v3.x + v4.x + v2.x) / 3;
            pl.y = (v1.y + v2.y + v3.y) / 3;
            pl2.y = (v3.y + v4.y + v2.y) / 3;
            pl.z = (v1.z + v2.z + v3.z) / 3;
            pl2.z = (v3.z + v4.z + v2.z) / 3;
        }
        private function curvePoint(uu:Number):Vector3D
        {
            uu /= 2;
            return new Vector3D(
                2*Math.sin(uu*p) - Math.sin(uu),
                2*Math.cos(uu*p) + Math.cos(uu),
                Math.sin(uu*q)
            );
        }
        private function calc(uu:Number, vv:Number):Number3D
        {
            var p:Vector3D = curvePoint(uu);
            var pn:Vector3D = curvePoint(uu+0.0001);
            var t:Vector3D = pn.subtract(p);
            var n:Vector3D = pn.add(p);
            var b:Vector3D = t.crossProduct(n);
            n = b.crossProduct(t);
            n.normalize();
            b.normalize();

            var sc:Number = 80;
            var cx:Number = d * sc * Math.sin(vv);
            var cy:Number = d * sc * -Math.cos(vv);
            // txt.text += cx + " " + cy + "\n";
            // txt.text += n.x + " " + n.y + " " + n.z + "\n";
            // txt.text += b.x + " " + b.y + " " + b.z + "\n\n";
            return new Number3D(
                p.x*sc + cx*n.x + cy*b.x, 
                p.y*sc + cx*n.y + cy*b.y, 
                p.z*sc + cx*n.z + cy*b.z
            );
        }
    }
}
import org.papervision3d.core.geom.TriangleMesh3D;
import org.papervision3d.core.math.NumberUV;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.core.math.Number3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.geom.renderables.Triangle3D;
class MyPlane extends TriangleMesh3D
{
    public function MyPlane(m:MaterialObject3D, v1:Number3D, v2:Number3D, v3:Number3D)
    {
        super( m, new Array(), new Array(), null );
        
        var vertices:Array = this.geometry.vertices;
        var faces:Array = this.geometry.faces;
        var centerX:Number =  (v1.x + v2.x + v3.x) / 3 ;
        var centerY:Number =  (v1.y + v2.y + v3.y) / 3 ;
        var centerZ:Number =  (v1.z + v2.z + v3.z) / 3 ;
        vertices.push(new Vertex3D(v1.x-centerX, v1.y-centerY, v1.z-centerZ));
        vertices.push(new Vertex3D(v2.x-centerX, v2.y-centerY, v2.z-centerZ));
        vertices.push(new Vertex3D(v3.x-centerX, v3.y-centerY, v3.z-centerZ));
        
        faces.push(new Triangle3D(this, [ vertices[0], vertices[1], vertices[2] ], m, [  new NumberUV(0,0), new NumberUV(0,1),new NumberUV(1,0) ] ) );

        this.geometry.ready = true;
    }
}