/**
 * Copyright imo_ ( http://wonderfl.net/user/imo_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6luR
 */

package {
    import flash.utils.ByteArray;
    import flash.display.Sprite;
    import com.bit101.components.*;
    public class Base71 extends Sprite {
        private var ta:TextArea;
        
        public function Base71() {
            Style.embedFonts = false;
            Style.fontName = "Courier New";
            Style.fontSize = 12;
            ta = new TextArea(this, 0, 0, "");
            ta.editable = false;
            ta.width = 465;
            ta.height = 465;
            process();
        }
        
        private function log(txt:Object):void {
            ta.text += txt;
        }
        
        private function process():void {
            var bytes:ByteArray = new ByteArray();
            bytes.writeUTFBytes("leL9wEHU.SWtPWg0ZFNb.vabOj(Lkgmsdw*EYY.hcH2d4kgQ1EDRngHWHIedn.cRgU2d4igQaYCxYbFW4nPc2Wc1YbEW4rQdGZ.HY.LWUt_t7NE_IqgYbMg41ub(odvab9g4U(eLqC7Y.QWtEW4csENtCbggHWH7eE-YP!rUr_Uq8RxOD*dUNWgkh1bYofebGW4thdPZbJe.RWtSWtlxopbQxnEIWH9jPSeb5bbGW4u)crebJebGW46ZeyiSma.LgtHWHUqoMYCOWgHWHYs1Cbo~ebFW4i2e6ZeCe.YgtKdHtEQ_YbKWULWUK00UUoThy(W9YYClabEW4)GdZYbWP16dHZrcR_Dga.QWtKWU6jCWYPJWUWp8Me.MWUPWgXx.jYoJebGW46ZeWbbKYbEW4W0cO(F0YPEW4ITc~XEYY.kctZgU8NRcYbKWUr'");
            log(encodeBase71(bytes));
        }
        
        private function encodeBase71(data:ByteArray):String {
            var chars:String = "!'()*-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~";
            
            var len:int = data.length;
            
            var buffer:int = 0;
            var numBufferBits:int = 0;
            var tmp:int;
            var tmp2:int;
            
            var idx:int = 0;
            
            var result:String = "";
            
            for (var i:int = 0; i < len; i++) {
                buffer = buffer << 8 | data[i];
                numBufferBits += 8;
                
                if (numBufferBits >= 19) {
                    
                    // in base 71, the maximum value we can store in three letters is
                    // 71^3 - 1 = 357910
                    //          = 0000 0101 0111 0110 0001 0110
                    // then set the 19th bit zero, we get
                    //    95766 = 0000 0001 0111 0110 0001 0110
                    
                    tmp = buffer & 0x3ffff; // first 18 bits
                    if (tmp > 95766) {
                        // we cannot store 19 bits in three latters if the 19th bit is one
                        buffer >>= 18;
                        numBufferBits -= 18;
                    } else {
                        // we can store 19 bits in three letters regardless of the 19th bit
                        tmp = buffer & 0x7ffff; // first 19 bits
                        buffer >>= 19;
                        numBufferBits -= 19;
                    }
                    
                    tmp2 = tmp / 71;
                    result += chars.charAt(tmp - tmp2 * 71);
                    tmp = tmp2 / 71;
                    result += chars.charAt(tmp2 - tmp * 71);
                    result += chars.charAt(tmp);
                }
            }
            
            if (numBufferBits != 0) {
                tmp = buffer / 71;
                result += chars.charAt(buffer - tmp * 71);
                if (numBufferBits > 7 || tmp != 0) {
                    tmp2 = tmp / 71;
                    result += chars.charAt(tmp - tmp2 * 71);
                    if (numBufferBits > 13 || tmp2 != 0) {
                        result += chars.charAt(tmp2);
                    }
                }
            }
            
            return result;
        }


    }
}