/**
 * Copyright asobuno2010 ( http://wonderfl.net/user/asobuno2010 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6lpH
 */

// forked from asobuno2010's flash on 2010-12-14
// クリックすると3Dシェイプがまわりながら拡大して消えてく--マージ失敗

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.utils.Timer;
    
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import com.flashdynamix.motion.Tweensy;
    
    public class cubeAnime1 extends Sprite {
        private var camera    :Camera3D;
        private var scene     :Scene3D;
        private var viewport  :Viewport3D;
        private var renderer  :BasicRenderEngine;

        private var cube      :Cube;
        
        public function cubeAnime1():void {
            // クリックイベントを監視する
            stage.addEventListener("click", clickHandler);
        }

        private function clickHandler(event:MouseEvent):void {
            // 3DCubeを作成
            camera   = new Camera3D();
            camera.x = 0;
            camera.y = 0;
            camera.z = -1000;
        
            scene    = new Scene3D();
            viewport = new Viewport3D( stage.stageWidth, stage.stageHeight, false, true );
            renderer = new BasicRenderEngine();
            addChild( viewport );

            var light:PointLight3D = new PointLight3D(false);
            light.x = 0;
            light.y = 0;
            light.z = -1000;

            var material :FlatShadeMaterial = new FlatShadeMaterial(light, Math.random()*0x1000000);
            material.interactive = true;

            var materials :MaterialsList = new MaterialsList( { all : material } );
            cube = new Cube( materials );
            cube.x = 0;
            cube.y = 0;
            cube.z = 0;
            cube.addEventListener( InteractiveScene3DEvent.OBJECT_CLICK, function(e :InteractiveScene3DEvent) :void {
                Tweensy.to( camera, { z :camera.z+100 }, 0.3, null, 0, null, function() :void {
                    Tweensy.to( camera, { z: -1000 }, 0.3 );
                });
            });
            scene.addChild( cube );

            //addEventListener( Event.ENTER_FRAME, onEnterFrame );
        
            // 円を作成
            /*var s:Sprite = new Sprite();
            s.graphics.beginFill(Math.random() * 0x1000000);
            s.graphics.drawCircle(10, 0, 10);
            s.graphics.endFill();
            s.scaleX = s.scaleY = 0;
            addChild(s);*/

            // 円をクリックされた位置に移動
            cube.x = event.stageX;
            cube.y = event.stageY;
            
            // 回転の方向をランダムにさせる
            var kakudo:int = xGetRandomInt(-2, 2);
            function xGetRandomInt(nMin:Number, nMax:Number):int {
                var nRandom:int = Math.floor(Math.random() * (nMax-nMin+1))+nMin;
                return nRandom;
            }

            // タイマー開始
            var timer:Timer = new Timer(50, 20);
            timer.start();
            timer.addEventListener("timer", function(event:Event):void {
                var ratio:Number = timer.currentCount / timer.repeatCount;
                cube.alpha = 1 - ratio;
                cube.scaleX = 20 * ratio;
                cube.scaleY = 20 * ratio;
                //cube.rotation = kakudo * 180 * ratio;
            });
            //timer.addEventListener("timerComplete", function(event:Event):void {
                //removeChild(cube);
            };
        }
    }
//}