/**
 * Copyright fujiopera ( http://wonderfl.net/user/fujiopera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6k3K
 */

// forked from fujiopera's forked from: notes on XML
// forked from wh0's notes on XML
package {
    import com.actionscriptbible.Example;
    public class FlashTest extends Example {
        public function FlashTest() {
            // these little empty tags make an XMLList, not an XML object.
            var list:XMLList = <></>;
            trace("listの数は" + list.length());
            // you can populate XMLList like an array
            list[0] = <a/>;
            list[2] = <b/>;
           trace("listの数は" + list.length());
            // it automatically squishes out any sparseness
            trace(list[1].toXMLString()); // <b/>
            
            // constructing XML(String) parses it instead of making a text node
            var foo:XML = new XML('<foo/>');
            trace(foo.toXMLString());
            // invalid syntax will cause an error
            var str:String = '1 < 2';
            try {
                new XML(str);
            } catch(e:Error) {
                trace(e);
            }
            // then how do you create an text node from a string?
            // escape it... AVM2 has "esc_xelem" op, but we don't have access to that
            var text:XML = new XML(str.replace(/</g, '&lt;'));
            trace(text);
            // something kludgy...
            var text2:XML = <>{str}</>[0];
            trace(text2);
            
            // what happens when you use E4X?
            var e4x:XML = <span><img /></span>;
            // bytecode is more like:
            // local = new XML('<span><img /></span>');
            // i.e., it's parsed at run time.
            trace(e4x.toXMLString());
            var fancy:XML = <div>{'before' + <test/> + 'after'}</div>;
            // bytecode is more like:
            // local = new XML('<div>' + __esc_xelem('before ' + new XML('<test/>') + ' after') + '</div>');
            // notice that this would implicitly call toString() on <test/>,
            // which would return nothing, since it is "simple"
            trace(fancy.toXMLString()); // nothing between before and after
            var fancier:XML = <div>{<test/>}</div>;
            trace(fancier.toXMLString()); // <div><test/></div>
            // note that now the argument is of type XML, which survives
            
            // what happens when you use filtering?
            var haystack:XMLList =
                <>
                    <i f="y"/>
                    <j f="n"/>
                    <k f="y"/>
                </>;
            var ik:XMLList = haystack.(@f == 'y');
            // bytecode is more like:
            // var _nodes:XMLList = haystack;
            // var _i:int = 0;
            // var _result:XMLList = new XMLList('');
            // while (__hasnext2(_nodes, _i)) { // this sets _i to the next key
            //     var _node = _nodes[_i];
            //     with (_node) {
            //         if (@f == 'y') {
            //             _result[_i] = _node;
            //         }
            //     }
            // }
            // ik = _result;
            trace(ik);
        }
    }
}