/**
 * Copyright mousman ( http://wonderfl.net/user/mousman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6jwt
 */

// forked from _shimizu's パーティクルの描画
package {
	import flash.text.TextFormat;
	import flash.text.TextField;

	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.display.Bitmap;
	import flash.geom.ColorTransform;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    
    [SWF(width=465,height=465,backgroundColor=0,frameRate=40)]
    public class FlashTest extends Sprite {
    		private var bmpdata:BitmapData;
    		private var colortrans:ColorTransform;
    		private var filter:BlurFilter;
    		private var vectormap:BitmapData;
    		private var particles:Array;
    		private var particle_number:uint = 25000;
    		private var size:Number = 465;
		private var largeur:int = 465;
		private var compteur:int = 10;
		private var perlincpt:int = 0;
		private var flux:int = 10;   
        
        public function FlashTest() {
        		//bitmapdataを作成して表示リストに追加
        		bmpdata = new BitmapData( size, size, false, 0);
        		addChild( new Bitmap(bmpdata));
        		//エフェクト初期化
        		colortrans = new ColorTransform( 0.92, 0.95, 0.95 );
        		filter = new BlurFilter( 24, 24, 1);
        		//ベクトルマップとパーティクルの初期化
        		vectormap = new BitmapData( size, size, false, 0);
        		reset();
        		//イベント
        		addEventListener( Event.ENTER_FRAME, enterframe);
        		stage.addEventListener( MouseEvent.CLICK, reset );
        		
                		
            
        }
        private function reset(e:MouseEvent = null):void{
 			setVectormap();       		
        		//パーティクルの初期化
        		particles = new Array(particle_number);
        		for( var i:int = 0; i < flux; i++){
        			particles[i] = new Particle((size-largeur)/2 + Math.random()*largeur/2,size);        			
        		}
        }
  		private function setVectormap():void {
        		var randomSeed:int = Math.random() * 0xFFFFFFFF;
        		var colors:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN;
        		vectormap.perlinNoise( size/2, size/2, 4, randomSeed, true, false, colors);
		}      
        private function enterframe(e:Event):void{
        		//エフェクトの適用
        		//bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
        		bmpdata.colorTransform( bmpdata.rect, colortrans);
        		//パーティクルの描画
        		bmpdata.lock();
			var nb:int = compteur;
        		perlincpt ++;
        		// regénération de la carte toutes les 3 secondes
			if (perlincpt / stage.frameRate > 3) {
					setVectormap();
					perlincpt = 0;
			}        		
        		for( var i:int = 0; i <nb; i++){
        			var p:Particle = particles[i];
        			
        			//ベクトルマップのPixel値から加速度を算出
        			var col:uint = vectormap.getPixel( p.x, p.y );
        			p.ax += ( ( col >> 16 & 0xff ) -64) * 0.0002;
        			p.ay += ( ( col >> 8 & 0xff ) - 128) * 0.0002;
        			//加速度から速度と位置を算出
        			p.x += p.vx += p.ax;
        			p.y += p.vy += p.ay;
        			
        			if ( p.x > size ) {
						p.vx = p.ax = 0;
						p.vy = p.ay = 0;	        				
						p.x = (size-largeur ) / 2 + Math.random() * largeur;
						p.y = size;
						}
        			else if ( p.x < 0 ) { 
						p.vx = p.ax = 0;
						p.vy = p.ay = 0;	        			
						p.x = (size -largeur) / 2 + Math.random() * largeur;
						p.y = size;
						}
        			if ( p.y > size ) { 
						p.vx = p.ax = 0;
						p.vy = p.ay = 0;	        			
						p.x = (size-largeur ) / 2 + Math.random() * largeur;
						p.y = size; 
					}
        			else if ( p.y < 0 ) {
						p.vx = p.ax = 0;
						p.vy = p.ay = 0;	        				
						p.x = (size-largeur) / 2 + Math.random() * largeur;
						p.y = size; 
					}
        			
        			//Pixelへの描画
        			bmpdata.setPixel( p.x, p.y, 0xaaaadd );
        			//加速度と速度の減衰
        			p.ax *= 0.96; p.ay *= 0.96;
        			p.vx *= 0.92; p.vy *= 0.92;

        		}
			if (compteur < particle_number) {
				for ( var j:int = compteur; j < compteur + flux; j++) {
					particles[j] = new Particle((size - largeur) / 2 + Math.random() * largeur, size);        
				}
				compteur += flux;
			}        		
			bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);        		
        		bmpdata.unlock()
        		
        }

    }
}

class Particle{
	//位置
	public var x:Number;
	public var y:Number;
	//加速度
	public var ax:Number = 0;
	public var ay:Number = 0;
	//速度
	public var vx:Number = 0;
	public var vy:Number = 0;
	
	function Particle( px:Number, py:Number){
		x = px;
		y = py;
	}
}