/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6igf
 */

/*
drawTrianglesの練習その2。
赤丸をマウスでドラッグして変形です。
※ 使用の画像は某自然動物公園で撮影してきたカンガルーのような小動物です。
*/
package  {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.display.LoaderInfo;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.system.Security;
    import flash.events.MouseEvent;
    
    [SWF(width=465, height=465, backgroundColor=0,frameRate=30)]
    public class Main extends Sprite{
        
        private var _vertices:Vector.<Number> = new Vector.<Number>()
        private var _indices:Vector.<int> = new Vector.<int>()
        private var _uvData:Vector.<Number> = new Vector.<Number>()
        private var _pX:Vector.<Number> = new Vector.<Number>()
        private var _pY:Vector.<Number> = new Vector.<Number>()
        private var _dotList:Vector.<Dot> = new Vector.<Dot>()
        private var _bmd:BitmapData
        private var _bm:Bitmap
        private var _shape:Shape = new Shape()
        
        private var _loader:Loader
        private var _req:URLRequest
        
        private var _xLen:int = 8   
        private var _yLen:int = 8
        
        public function Main() {
            Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
            loadImage("http://www.digifie.jp/files/test100726.jpg")
        }
        
        private function loadImage(url:String):void{
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadedListener);
            _loader.load(new URLRequest(url));
        }
        private function onLoadedListener(e:Event):void {
            addChild(_shape)
            _bmd = new BitmapData(_loader.width, _loader.height, false, 0)
            _bmd.draw(_loader)
            //
            for (var i:int=0; i < _xLen; i++){
                for (var j:int=0; j < _xLen; j++){
                    _uvData.push(j / (_xLen-1), i / (_yLen-1));
                    _vertices.push(_bmd.width * j / (_xLen-1), _bmd.height * i / (_yLen-1));
                    _pX.push(_bmd.width * j / (_xLen-1));
                    _pY.push(_bmd.height * i / (_yLen-1));

                    if (i != (_yLen - 1) && j != (_xLen - 1)){
                        _indices.push(_xLen * i + j, _xLen * i + j + 1, _xLen * (i + 1) + j);
                        _indices.push(_xLen * i + j + 1, _xLen * (i + 1) + j, _xLen * (i + 1) + j + 1);
                    }
                }
            }
            
            for (i=0; i < _xLen * _yLen; i++){
                var dot:Dot = new Dot()
                dot.x = _pX[i]
                dot.y = _pY[i]
                addChild(dot)
                _dotList.push(dot)
                _dotList[i].addEventListener(MouseEvent.MOUSE_DOWN, dragStart)
                _dotList[i].addEventListener(MouseEvent.MOUSE_UP, dragStop)
            }
            
            createTriangles(_vertices, _indices, _uvData)    
        }
        
        private function dragStart(e:MouseEvent):void{
            e.target.startDrag(true)
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function dragStop(e:MouseEvent):void{
            e.target.stopDrag()
            removeEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void{
            var n:Number = 0.01
            var nX:int=0
            var nY:int=0
            for (var i:int=0; i < _vertices.length; i++){
                if(i%2 != 1){
                    if(nX<_dotList.length){
                        _vertices[i] = _dotList[nX].x
                        nX++
                    }
                }else{
                    if(nY<_dotList.length){
                        _vertices[i] = _dotList[nY].y
                        nY++
                    }
                }
            }
            createTriangles(_vertices, _indices, _uvData)    
        }
        
        private function createTriangles(ver:Vector.<Number>, ind:Vector.<int>, uv:Vector.<Number>, cull:String = "none"):void{
            _shape.graphics.clear();
            _shape.graphics.lineStyle(1, 0xFFFFFF, 0.5)
            _shape.graphics.beginBitmapFill(_bmd, null, true, true)
            _shape.graphics.drawTriangles(ver, ind, uv, cull)
            _shape.graphics.endFill()
        }

    }
}
import flash.display.Sprite;
import flash.display.Shape;
class Dot extends Sprite{
    public function Dot(){
        var shape:Shape = new Shape()
        addChild(shape)
        shape.graphics.beginFill(0xFF0000, 0.5)
        shape.graphics.drawCircle(0,0,5)
        shape.graphics.endFill()
    }
}