/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6hqG
 */

package{
	import flash.display.Sprite;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;

	public class Web2Badge extends Sprite{
		private const LINE_COLOR:uint = 0xffffff;
		private const BODY_COLOR1:uint = 0xffff66;
//		private const BODY_COLOR2:uint = 0xffcc00;
		private const BODY_COLOR2:uint = 0x66cc00;
//		private const CORNER:int = 12;
		private const CORNER:int = 5;
		private const RADIUS1:Number = 26;
		private const RADIUS2:Number = 22;
//		private const TEXT:String = "BETA";
		private const TEXT:String = "SLOPE";

		public function Web2Badge(){
			var d:Number = Math.min(RADIUS1,RADIUS2) * 2;
			var s:Sprite = new Sprite();
			s.graphics.lineStyle(1,LINE_COLOR);
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(d,d,-Math.PI / 4);
			s.graphics.beginGradientFill("linear",[BODY_COLOR1,BODY_COLOR2],[1,1],[0,255],matrix);
			var angle:Number = 2 * Math.PI / CORNER;
			var p1:Point,p2:Point;
			s.graphics.moveTo(RADIUS1,0);
			for(var i:int=0;i<CORNER;i++){
				p1 = Point.polar(RADIUS2,angle * (i + 0.5));
				p2 = Point.polar(RADIUS1,angle * (i + 1));
				s.graphics.lineTo(p1.x,p1.y);
				s.graphics.lineTo(p2.x,p2.y);
			}
			s.graphics.endFill();
			s.filters = [new DropShadowFilter(4,45,0,0.5)];
//			var size:int = d / TEXT.length;
			var size:int = 10;
			var text:TextField = new TextField();
			text.htmlText = '<font size="' + size + '" color="#ff0000">' + '<b>' + TEXT + '</font></b>';
			text.x = -text.textWidth / 2;
			text.y = -text.textHeight / 2;
			text.filters = [new DropShadowFilter(1,45,0,0.8)];
			s.addChild(text);
			s.x = s.y = 200;
			addChild(s);
		}
	}
}
