/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6hWh
 */

// forked from tkinjo's forked from: インボリュート曲線を Lines3D で描く
// forked from tkinjo's インボリュート曲線を Lines3D で描く
// forked from tkinjo's ターゲットの周りを飛ぶキューブ
// forked from tkinjo's インボリュート曲線を Lines3D で描く
// forked from tkinjo's ターゲットの周りを飛ぶキューブ
package  
{
    /**
     * Lorenz's Strange Attractor
     * 
     * --- 参考 ---
     * Lorenz's Strange Attractor
     * http://www.sat.t.u-tokyo.ac.jp/~hideyuki/java/Attract.html
     */
    
    import flash.events.Event;
    import flash.geom.*;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    [SWF(width=465,height=465,frameRate=60,backgroundColor=0xffffff)]
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends BasicView
    {
        private const RADIUS:Number = -1000;
        private const SCALE:Number = 10;
        
        private var linesVectors:Vector.<Lines3D>;
        private var point:Vector3D;
        private var previousPoint:Vector3D;
        
        public function Main() 
        {
            linesVectors = new Vector.<Lines3D>();
            
            var wireframeMaterial:WireframeMaterial = new WireframeMaterial( 0 );
            wireframeMaterial.doubleSided = true;
            
            var plane:Plane = new Plane( wireframeMaterial );
            plane.rotationX = 90;
            
            scene.addChild( plane );
            
            //camera.x = 1000;
            //camera.y = 1000;
            camera.target = null;
            //camera.zoom = 115;
            
            point = new Vector3D( 0, 20, 20 );
            previousPoint = new Vector3D( 0, 20, 20 );
            
            startRendering();
            
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
        }
        
        
        /**
         * 
         * @param    event
         */
        private function enterFrameHandler( event:Event ):void {
            
            var lineMaterial:LineMaterial = new LineMaterial();
            var lines:Lines3D = new Lines3D( lineMaterial );
            
            atractor();
            
            lines.addNewLine( 3, previousPoint.x * SCALE, previousPoint.y * SCALE, previousPoint.z * SCALE, point.x * SCALE, point.y * SCALE, point.z * SCALE );
            scene.addChild( lines );
            
            linesVectors.push( lines );
            
            previousPoint = point.clone();
            
            
            /**
             * カメラの設定
             */
            var thetaXZ:Number=360 * ( ( mouseX + stage.stageWidth / 2 ) / stage.stageWidth ) * Math.PI / 180;
            var thetaYZ:Number=360 * ( ( mouseY + stage.stageHeight / 2 ) / stage.stageHeight ) * Math.PI / 180;
            camera.x = RADIUS * Math.cos( thetaYZ ) * Math.sin( thetaXZ );
            camera.y = -RADIUS * Math.sin( thetaYZ );
            camera.z = RADIUS * Math.cos( thetaYZ ) * Math.cos( thetaXZ );
            camera.rotationX = thetaYZ * 180 / Math.PI;
            camera.rotationY = thetaXZ * 180 / Math.PI;
        }
        
        
        private function atractor():void {
            
            point.x = previousPoint.x + 0.01 * ( -10 * previousPoint.x + 10 * previousPoint.y);
            point.y = previousPoint.y + 0.01 * (28 * previousPoint.x - previousPoint.y - previousPoint.x * previousPoint.z);
            point.z = previousPoint.z + 0.01 * ( -8 * previousPoint.z / 3 + previousPoint.x * previousPoint.y);
        }
    }
}