/**
 * Copyright jidolstar ( http://wonderfl.net/user/jidolstar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ghp
 */

// forked from narutohyper's Alternativa3D WalkControlをプリミティブに使う
// forked from clockmaker's [Alternativa3D] Basic Template

package {
	import alternativ5.engine3d.controllers.CameraController; 
	import alternativ5.engine3d.controllers.WalkController; 
	import alternativ5.engine3d.controllers.ObjectController

	import alternativ5.engine3d.materials.FillMaterial;
	import alternativ5.engine3d.materials.DevMaterial;
	import alternativ5.engine3d.materials.TextureMaterial
	import alternativ5.engine3d.primitives.Plane;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.engine3d.primitives.Sphere;
	import alternativ5.engine3d.events.MouseEvent3D
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.types.Texture;
	import alternativ5.types.Point3D;
	import alternativ5.types.Matrix3D;

	import alternativ5.utils.MathUtils;
	import alternativ5.utils.KeyboardUtils; 

	import flash.display.Sprite;
	import flash.display.BlendMode
	import flash.display.BitmapData
	import flash.geom.Matrix;
	import flash.geom.Rectangle;


	[SWF(width = 465, height = 465, frameRate = 24)]
	/**
	 * Alternativa3D WalkControlをプリミティブに使う
	 * 
	 * カメラのコントローラーとして使われる、WalkController、CameraControllerですが
	 * コントロール対象として指定できるのは、object3D型なので、カメラに限らず指定できます。
	 * なので、Object3D型の空Objectに、プリミティブとカメラを突っ込み、Object後方視点のコントロールができます。
	 * 
	 * 迷路は色々出てるので、ちょっとカーシミュレーター風にしてみました
	 * （全然手抜きですがｗ）。
	 * 
	 * ↑(W)←(A)→(S)↓(Z)で操作できます
	 *
	 *　スペースでジャンプもできますが、たまに奈落に墜落しますｗ
	 *　墜落したら、再起動で
	 * 
	 * 後は、低ポリで作った地形マップと車を3dsで読み込んじゃえば、
	 * そんなに、がんばらなくても、それっぽいドライブシミュレーションもできちゃいますｗ
	 * たぶん・・・
	 * 
	 * @narutohyper
	 */


	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */

	
	public class SimpleDemo extends Sprite {

		public function SimpleDemo():void {
			var startPoint:Point3D=new Point3D(1375,-2000,20)

			// テンプレートを作成します

			var template:BasicTemplate = new BasicTemplate();
			addChild(template);


			//baseを作る
				var base:Box=new Box(3000,5000,120,12,20,1,true);
				base.cloneMaterialToAllSurfaces(new DevMaterial(0,0xCCCCCC,20,false,0,0,255,1,BlendMode.NORMAL,1,0x666666));
				var bmd:BitmapData = new BitmapData(300,300,true,0x00000000);
				base.setMaterialToSurface(new TextureMaterial(new Texture(bmd)),'top');
				template.scene.root.addChild(base);
				base.z=60;

				var wall:Box=new Box(2500,4500,120,10,18,1,false);
				wall.cloneMaterialToAllSurfaces(new DevMaterial(0,0xCCCCCC,20,false,0,0,255,1,BlendMode.NORMAL,1,0x666666));
				template.scene.root.addChild(wall);
				wall.z=60;




			// rightを作成
				var light:Sphere = new Sphere(30);
				light.cloneMaterialToAllSurfaces(new FillMaterial(0xCCCC00));
				light.coords=new Point3D(-800,800,800);
				template.scene.root.addChild(light);


			// 車＆カメラを作成
				var carAndCamera:Object3D = new Object3D()
				template.scene.root.addChild(carAndCamera);

				var car:shadingBox = new shadingBox(20, 40, 10)
				car.originalDevMaterial(0x0000FF);
				carAndCamera.addChild(car)
								
				template.camera.fov = MathUtils.toRadian(64)
				template.camera.rotationX = MathUtils.toRadian(-90)
				carAndCamera.addChild(template.camera)
				template.camera.coords=new Point3D(0,-150,30)


			//WalkControllerを作成、カメラ搭載車を対象オブジェクトに
				var carController:WalkController = new WalkController(template.stage,carAndCamera); 

				carController.checkCollisions=true
				carController.setDefaultBindings(); 
				carController.bindKey(KeyboardUtils.UP, ObjectController.ACTION_FORWARD); 
				carController.bindKey(KeyboardUtils.DOWN, ObjectController.ACTION_BACK); 

				carController.speed = 700; 
				carController.maxGroundAngle = MathUtils.toRadian(50);
				carController.gravity = 600; 
				carController.objectZPosition = 0.7; 
				carController.coords = startPoint;
				carController.jumpSpeed = 400; 

				carController.collider.radiusX = 20;
				carController.collider.radiusY = 40;
				carController.collider.radiusZ = 10;

			var nextCoords:Point3D=new Point3D()
			var nowCoords:Point3D=new Point3D()
			var zAxis:Point3D=new Point3D()
			var mtr:Matrix3D=new Matrix3D()
			var rotations:Point3D=new Point3D()


			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			
			template.onPreRender = function():void {
				carController.processInput();

				car.shading(light)

				//ジャンプ時の車の向きを求める

				//コントローラーを介して車の現在位置を取得
				//前回の位置との方向ベクトルを取得。それを車の角度に反映
				carController.readCoords(nowCoords)

				zAxis= Point3D.difference(nextCoords,nowCoords);
				zAxis.normalize();
				if(zAxis.z < 1 ) {
					mtr=new Matrix3D()

					mtr.a =	zAxis.x
					mtr.e =	zAxis.y
					mtr.i =	zAxis.z

					rotations = mtr.getRotations();
					car.rotationX=rotations.y/2
				} else {
					car.rotationX=0
				}

				nextCoords.copy(nowCoords)

			}
		}


	}


}










//----------------------------------------------------------------------------------------------------------------
//ここから下は、フラットシェーディングで使用した物と同じ
//----------------------------------------------------------------------------------------------------------------

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.display.BlendMode
import flash.events.Event;
import flash.geom.Rectangle
import flash.geom.ColorTransform

import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.types.Texture;
import alternativ5.types.Point3D;
import alternativ5.types.Matrix3D;
import alternativ5.engine3d.display.View;

import alternativ5.engine3d.primitives.Box;
import alternativ5.engine3d.primitives.Cone;
import alternativ5.engine3d.events.MouseEvent3D
import alternativ5.engine3d.materials.DevMaterial;
import alternativ5.engine3d.materials.FillMaterial;
import alternativ5.engine3d.materials.SurfaceMaterial;
import alternativ5.engine3d.materials.TextureMaterial
import alternativ5.utils.MathUtils;

/**
 * 追記
 * フラットシェーディングするbox
 */
class shadingBox extends Box{

	private var effectUtl:effectUtility;

	private var textureObj:Object;


	public function shadingBox(width:Number = 100, length:Number = 100, height:Number = 100, widthSegments:uint = 1, lengthSegments:uint = 1, heightSegments:uint = 1, reverse:Boolean = false, triangulate:Boolean = false) {
		super(width, length, height, widthSegments, lengthSegments, heightSegments, reverse, triangulate);
		effectUtl=new effectUtility(this);
		textureObj={}

	}


	public function lookAt(targetObject:*, upAxis:Point3D=null ):void {
		effectUtl.lookAt(targetObject, this.getFaceById('top_0_0').normal)
	}

	public function originalDevMaterial(color:uint):void {
		//originalのフラットシェーディングできるTextureを作成
		textureObj.top		=	new originalDevTexture(color);
		textureObj.front	=	new originalDevTexture(color);
		textureObj.right	=	new originalDevTexture(color);
		textureObj.bottom	=	new originalDevTexture(color);
		textureObj.back		=	new originalDevTexture(color);
		textureObj.left		=	new originalDevTexture(color);

		//各materialにTextureをセット
		this.setMaterialToSurface(new TextureMaterial(textureObj.top)			,'top');
		this.setMaterialToSurface(new TextureMaterial(textureObj.front)		,'front');
		this.setMaterialToSurface(new TextureMaterial(textureObj.right)		,'right');
		this.setMaterialToSurface(new TextureMaterial(textureObj.bottom)		,'bottom');
		this.setMaterialToSurface(new TextureMaterial(textureObj.back)			,'back');
		this.setMaterialToSurface(new TextureMaterial(textureObj.left)			,'left');
		
	}


	public function shading(targetObject:*):void {
		//光源(targetObject)に対してshadingLvを求め、Textureを変更
		textureObj.top.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('top_0_0').normal)));
		textureObj.front.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('front_0_0').normal)));
		textureObj.right.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('right_0_0').normal)));
		textureObj.bottom.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('bottom_0_0').normal)));
		textureObj.back.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('back_0_0').normal)));
		textureObj.left.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('left_0_0').normal)));

	}

	private function toDegree(no:Number):uint {
		var result:uint =Math.round(Math.abs(MathUtils.toDegree(no)));
		return result;
	}

}



//originalのフラットシェーディングできるTextureを作成するクラス
class originalDevTexture extends Texture{
	private var shadeBm:Bitmap;
	private var tempSprite:Sprite;

	public function originalDevTexture(color:int,_width:Number=10,_height:Number=10) {

		tempSprite = new Sprite();
		tempSprite.addChild(new Bitmap(new BitmapData(_width,_height, true, 0xFF000000 | color)))

		shadeBm = new Bitmap(new BitmapData(_width,_height, true, 0xFFFFFFFF))
		shadeBm.blendMode=BlendMode.HARDLIGHT
		tempSprite.addChild(shadeBm)

		super(new BitmapData(_width,_height, true, 0xFFFFFFFF));

		this.bitmapData.draw(tempSprite)
	}

	public function shadeLv(_lv:uint):void {
		//shadingLvでTextureをtranceform
		//0:明るい(100%[1])～180:暗い(0%[0])
		var cTransform:ColorTransform  = new ColorTransform();
		var lv:Number=(180-_lv)/180;

		cTransform.redMultiplier=lv
		cTransform.greenMultiplier=lv
		cTransform.blueMultiplier=lv
		shadeBm.transform.colorTransform = cTransform;

		this.bitmapData.draw(tempSprite)
	}

}




//プリミティブで使う、各種Utilityクラス
class effectUtility {

	private var thisObject:*
	public function effectUtility(mc:*) {
		thisObject=mc;
	}

	//光源に対してのシャドーLvを返す。
	public function shadowLv(targetObject:*, vAxis:Point3D=null ):Number {

		var position :Point3D = thisObject.coords;
		var target	 :Point3D = targetObject.coords;
		var result	 :Number = 0;

		//光源に対するZ方向(と距離)
		var zAxis 	 :Point3D = Point3D.difference(target,position);
		//光源への距離
		var length:Number =Math.sqrt(Math.pow(zAxis.x,2)+Math.pow(zAxis.y,2)+Math.pow(zAxis.z,2));

		//光源に対するZ方向(正規化)
		zAxis.normalize();

		//各面の法線は、faceから直接もらう

		if (vAxis) {
			//箱の方向で、各面の法線を回転
			var mtr	:Matrix3D = thisObject.transformation;
			mtr.d=0
			mtr.h=0
			mtr.l=0
			vAxis.transform(mtr)

			//内積を求めて、角度に変換(0:明るい～180:暗い)
			result=Math.acos(Point3D.dot(zAxis,vAxis))
		}

		return result;

	}


	public function lookAt(targetObject:*, vAxis:Point3D=null ):void {

		var position :Point3D = thisObject.coords;
		var target	 :Point3D = targetObject.coords;

		var zAxis 	 :Point3D = Point3D.difference(target,position);
		zAxis.normalize();

		if (!vAxis) {
			vAxis=new Point3D(0,1,0)
		}

		//var mtr	:Matrix3D = thisObject.transformation;
		//vAxis.transform(mtr)

		if( modulo(zAxis) > 0.1 ) {
			var xAxis :Point3D = Point3D.cross(vAxis, zAxis);
			xAxis.normalize();
			var yAxis :Point3D = Point3D.cross( zAxis, xAxis);
			yAxis.normalize();

			var look	:Matrix3D = thisObject.transformation;

			var mtr:Matrix3D=new Matrix3D()
			mtr.rotate(MathUtils.toRadian(90),MathUtils.toRadian(90),MathUtils.toRadian(90))
			vAxis.transform(mtr)

			look.a =	xAxis.x * thisObject.scaleX*reverseCheck(vAxis.x);
			look.e =	xAxis.y * thisObject.scaleX*reverseCheck(vAxis.x);
			look.i =	xAxis.z * thisObject.scaleX*reverseCheck(vAxis.x);
			
			look.b =	yAxis.x * thisObject.scaleY*reverseCheck(vAxis.y);
			look.f =	yAxis.y * thisObject.scaleY*reverseCheck(vAxis.y);
			look.j =	yAxis.z * thisObject.scaleY*reverseCheck(vAxis.y);
			
			look.c =	zAxis.x * thisObject.scaleZ*reverseCheck(vAxis.z);
			look.g =	zAxis.y * thisObject.scaleZ*reverseCheck(vAxis.z);
			look.k =	zAxis.z * thisObject.scaleZ*reverseCheck(vAxis.z);

			var rotations:Point3D = look.getRotations();
			
			thisObject.rotationX = rotations.x;
			thisObject.rotationY = rotations.y;
			thisObject.rotationZ = rotations.z;

		}

	}


	private function modulo(target:Point3D):Number {
		return Math.sqrt( target.x*target.x + target.y*target.y + target.z*target.z );
	}

	private function reverseCheck(no:Number):Number {
		var result:Number=1;
		if (no<0) result=-1;
		return result;
	}
	
}






/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		//cameraContoller = new CameraController(this);
		//cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
			//view.width = 1024;
			//view.height = 1024;
			//this.width = stage.stageWidth;
			//this.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}

