/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ghS
 */

/*
 * 間接の動きをシミュレートするための事始め
 *
 * パネルの左から根元、第１関節、第２間接…
 * パネルの上からZ, Y, X軸回転のプラス／マイナス
 *
 * 目標は自在に操って踊らせる
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=465,height=465,backgroundColor=0xeeeeee)]
	public class Main extends Sprite {
		
		private var SW:Number = stage.stageWidth;
		private var SH:Number = stage.stageHeight;
		private var bones:Array = new Array();
		
		public function Main():void {
			
			var panels:Sprite = new Sprite();
			addChild(panels);
			
			for (var i:uint = 0; i < 6; i++) {
				var bone:Bone = new Bone();
				bone.x = SW/2 + (i*50);
				bone.y = SH/2;
				bone.z = 0;
				addChild(bone);
				bones.push(bone);
			}
			
			var axises:Array = [Vector3D.Z_AXIS, Vector3D.Y_AXIS, Vector3D.X_AXIS];
			for (var j:uint = 0; j < 6; j++) {
				for (var v:uint = 0; v < 3; v++) {
					for (var t:uint = 0; t < 2; t++) {
						var param:Number = t == 0 ? 5 : -5;
						var cb:ControlButton = new ControlButton(bones.slice(j), axises[v], param);
						panels.addChild(cb);
						cb.x = 75 * j;
						cb.y = 150 * v + 75 * t;
						cb.addEventListener(MouseEvent.MOUSE_OVER, xStart);
					}
				}
			}
			
			panels.x = (SW - panels.width) / 2;
			panels.y = (SH - panels.height) / 2;
		}
		
		public function xStart(e:MouseEvent):void {
			e.target.addEventListener(Event.ENTER_FRAME, xControlButton);
			e.target.addEventListener(MouseEvent.MOUSE_OUT, xStop);
		}
		
		public function xStop(e:MouseEvent):void {
			e.target.removeEventListener(Event.ENTER_FRAME, xControlButton);
		}
		
		public function xControlButton(e:Event):void {
			
			var targets:Array = e.target.targets;
			var axis:Vector3D = e.target.axis;
			var param:Number  = e.target.param;
			
			var obj:Bone = targets[0];
			var pivot:Vector3D = new Vector3D(obj.x, obj.y, obj.z);
			
			for (var i:uint = 0; i < targets.length; i++) {
				obj = targets[i];
				obj.transform.matrix3D.appendTranslation(-pivot.x, -pivot.y, -pivot.z);
				obj.transform.matrix3D.appendRotation(param, axis);
				obj.transform.matrix3D.appendTranslation( pivot.x,  pivot.y,  pivot.z);
			}
		}
	}
}

import flash.display.Sprite;
import flash.geom.Vector3D;

class ControlButton extends Sprite {
	public var targets:Array;
	public var axis:Vector3D;
	public var param:Number;
	public function ControlButton(vTargets:Array, vAxis:Vector3D, vParam:Number):void {
		targets = vTargets;
		axis    = vAxis;
		param   = vParam;
		graphics.lineStyle(4,0xbbbbbb);
		graphics.beginFill(0xcccccc);
		graphics.drawRoundRect(0,0,65,65,30);
		buttonMode = true;
	}
}

class Bone extends Sprite {
	public function Bone():void {
		graphics.beginFill(0x333333);
		graphics.drawRoundRect(-10,-10,50,20,20);
	}
}