/**
 * Copyright swingpants ( http://wonderfl.net/user/swingpants )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6gds
 */

package 
{ 
    import flash.display.Sprite; 
    import flash.display.MovieClip;
    import flash.display.BitmapData 
    import flash.events.Event; 
    import flash.display.Graphics; 
    import org.papervision3d.materials.ColorMaterial; 
    import org.papervision3d.objects.primitives.Plane; 
    import org.papervision3d.objects.primitives.Cube; 
    import org.papervision3d.scenes.Scene3D; 
    import org.papervision3d.view.Viewport3D; 
    import org.papervision3d.cameras.Camera3D; 
    import org.papervision3d.render.BasicRenderEngine; 
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial
    import org.papervision3d.materials.utils.MaterialsList
    import org.papervision3d.materials.special.CompositeMaterial
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.BitmapMaterial
    import org.papervision3d.materials.*
    import org.papervision3d.lights.PointLight3D; 
    

    [SWF(width=480, height=480, backgroundColor=0x000000)] 

    public class PaperTest extends Sprite 
    { 
        public var renderer:BasicRenderEngine = new BasicRenderEngine();; 
        public var camera:Camera3D = new Camera3D(); 
        public var viewport:Viewport3D = new Viewport3D(600,600); 
        public var scene:Scene3D = new Scene3D(); 

        public var mat:ColorMaterial = new ColorMaterial(0xFF0000); 
        public var cubeMat:CompositeMaterial
        public var materialsList:MaterialsList = new MaterialsList();

        public var cube:Cube
        public var cubeSize:int=600
        
        public var panelMaterial:BitmapMaterial

        public function PaperTest() 
        { 
            //camera.x = 3000;
	    camera.z = -cubeSize*2;
	    camera.zoom = 10;
	    camera.focus = 10;

	    cube=buildCube()
            mat.doubleSided=false; 
            addChild(viewport) 
            
            scene.addChild(cube); 
            addEventListener(Event.ENTER_FRAME,onTick); 
        } 
        
        private function makeCube():Cube
        {
            //create cube 
            var ml:MaterialsList = new MaterialsList();
            ml.addMaterial(new ColorMaterial(0xff0000), 'all');
            
			
            var cubeObj:Cube = new Cube(ml, cubeSize, 2000, cubeSize, 1,1,1);

            return cubeObj
        }
        
        private function buildCube():Cube
        {
            var light:PointLight3D    = new PointLight3D( ); 
            
            var cubeMat:CompositeMaterial = new CompositeMaterial(); 
            cubeMat.addMaterial( createTexture() );
            cubeMat.addMaterial( new FlatShadeMaterial(light, 0xFFFF00, 0xAAAA00) ); 
            //cubeMat.addMaterial( new WireframeMaterial( 0x000000, 0.3 ) ); 
            //
            var cubeMatList:MaterialsList = new MaterialsList( ); 
            cubeMatList.addMaterial( createTexture(), "all" ); 
            var cubeObj:Cube = new Cube( cubeMatList, cubeSize, 2000, cubeSize, 4, 4, 4); 
            //cubeObj.y = cubeSize; 

            return cubeObj
        }
        
        private function createTexture(w:int=200,h:int=200, win_w:int=20,win_h:int=40):BitmapMaterial
        {
            var sprite:Sprite=new Sprite()
            
            
           // sprite.graphics.beginFill(0x00ff00);
            sprite.graphics.lineStyle(10, 0xffffff);
            sprite.graphics.drawRect(0,0,w,h)
            sprite.graphics.lineStyle(5, 0xffffff);
            
            var win_gap_w:Number=win_w*0.25
            var win_gap_h:Number=win_h*0.25
            var columns:int=(w-win_w/2)/(win_w+win_gap_w)
            var rows:int=(h-win_h/2)/(win_h+win_gap_h)
            win_gap_w=(w-columns*win_w)/(columns+1)
            win_gap_h=(h-rows*win_h)/(rows+1)
            
            for (var i:int=0;i<columns;i++)
                {
                    for(var j:int=0;j<rows;j++)
                        {
                            sprite.graphics.drawRect(win_gap_w+i*(win_w+win_gap_w), win_gap_h+j*(win_h+win_gap_h),win_w,win_h)
                        }
                }

            var bmd:BitmapData = new BitmapData(200, 200, false, 0x00000000);
            bmd.draw(sprite)
            return new BitmapMaterial(bmd)
        }
        
        private function onTick(evt:Event):void
	{ 
            cube.rotationY+=5; 
            cube.rotationX+=5; 

           renderer.renderScene(scene,camera,viewport); 
        } 
    } 
} 