/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6gGC
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.BlendMode;
    import flash.geom.ColorTransform;
    import flash.display.PixelSnapping;
    import flash.geom.Matrix;
    import flash.events.TimerEvent;
    import flash.utils.Timer; 
    import flash.events.MouseEvent;
    
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
    
    public class FlashTest extends Sprite {
        
        private const WIDTH:Number = 465;
        private const HEIGHT:Number = 465;
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _rect:Rectangle;
        private var _cTra:ColorTransform;
        private var _particles:Array;
        
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            _canvas = new BitmapData(WIDTH, HEIGHT, true, 0xFF000000);
            addChild(new Bitmap(_canvas));
            
            _glow = new BitmapData(WIDTH/4, HEIGHT/4, true, 0xFF000000);
            var bmp:Bitmap = new Bitmap(_glow, PixelSnapping.NEVER, true);
            bmp.blendMode = BlendMode.ADD;
            bmp.scaleX = bmp.scaleY = 4;
            addChild(bmp);
            
            _particles = new Array();
            _rect = new Rectangle(0, 0, WIDTH, HEIGHT);
            _cTra = new ColorTransform(.8, .8, .9, 1);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);     
            timer.start();  
        }
        
        private function onTimer(e:TimerEvent):void {
            var n:uint = 50;
            while(n--) {
                var p:Particle = new Particle();
                p.x = mouseX;
                p.y = mouseY;
                
                var radius:Number = Math.random() * 10;
                var angle:Number = Math.random() * Math.PI*2;
                p.vx = Math.cos(angle) * radius;
                p.vy = Math.sin(angle) * radius;
                
                _particles.push(p);
            }
        }            
        
        private function onEnterFrame(e:Event):void {
            _canvas.lock();
            
            for(var i:uint = 0; i<_particles.length; i++){
                var p:Particle = _particles[i];
                p.vy += 0.2;
                p.vx *= 0.9;
                p.vy *= 0.9;
                p.x += p.vx;
                p.y += p.vy;
                _canvas.setPixel32(p.x, p.y, p.c);
				if ((p.x > stage.stageWidth || p.x < 0) || (p.y < 0 || p.y > stage.stageHeight) || Math.abs(p.vx) < .01 || Math.abs(p.vy) < .01)
				{
					_particles.splice(i, 1);
				}
            }
            _canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(1,1));
            _canvas.colorTransform(_rect, _cTra);
            _canvas.unlock();
            _glow.draw(_canvas, new Matrix(1/4, 0, 0, 1/4));
        }
    }
}
internal class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var c:uint;
    
    public function Particle() {
        x = 0;
        y = 0;
        vx = 0;
        vy = 0;
        c = 0xFFFFFFFF;
    }
}