/**
 * Copyright sowcodWonderfl ( http://wonderfl.net/user/sowcodWonderfl )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6flQ
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.Graphics;
    public class FlashTest extends Sprite {
        private var sp:Sprite;
        private var time_t:Number;
        private var ps:Array = [4, 1, -1, 0]; // easing parameter
        public function FlashTest() {
            // iOS's easing curve?
            this.sp = this.createBall();
            this.sp.x = 30;
            this.sp.y = 30;
            this.addChild(sp);
            
            this.time_t = 0;
            this.addEventListener(Event.ENTER_FRAME, this.enterFrame);
        }
        private function createBall():Sprite {
            var sp:Sprite = new Sprite()
            var g:Graphics = sp.graphics;
            g.beginFill(0xff0000);
            g.drawCircle(0, 0, 10);
            return sp;
        }

        private function enterFrame(ev:Event):void {
            this.time_t += 0.02;
            
            if(this.time_t >= 1) {
                this.time_t = 1;
            } else {
                this.sp.x += easingFunc(this.ps[0], this.ps[1], this.ps[2], this.ps[3],
                    this.time_t) * 2;
            }
        }

        private function easingFunc(p0:Number, p1:Number, p2:Number, p3:Number, t:Number):Number {
            var t2:Number = 1 - t;
            return t2*t2*t2*p0 + 3*t*t2*t2*p1 + 3*t*t*t2*p2 + t*t*t*p3;
        }

    }
}